/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import org.json.JSONObject;
import org.keycloak.social.AbstractOAuth2Provider;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import org.keycloak.social.utils.SimpleHttp;

public class FacebookProvider
extends AbstractOAuth2Provider {
    private static final String ID = "facebook";
    private static final String NAME = "Facebook";
    private static final String AUTH_URL = "https://graph.facebook.com/oauth/authorize";
    private static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    private static final String PROFILE_URL = "https://graph.facebook.com/me";
    private static final String DEFAULT_SCOPE = "email";

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    protected String getScope() {
        return DEFAULT_SCOPE;
    }

    protected String getAuthUrl() {
        return AUTH_URL;
    }

    protected String getTokenUrl() {
        return TOKEN_URL;
    }

    protected SocialUser getProfile(String accessToken) throws SocialProviderException {
        try {
            JSONObject profile = SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken).asJson();
            SocialUser user = new SocialUser(profile.getString("id"), profile.getString("username"));
            user.setName(profile.optString("first_name"), profile.optString("last_name"));
            user.setEmail(profile.optString(DEFAULT_SCOPE));
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }

    public AuthRequest getAuthUrl(SocialProviderConfig config) throws SocialProviderException {
        return super.getAuthUrl(config);
    }
}

