/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import org.json.JSONObject;
import org.keycloak.social.AbstractOAuth2Provider;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import org.keycloak.social.utils.SimpleHttp;

public class GoogleProvider
extends AbstractOAuth2Provider {
    private static final String ID = "google";
    private static final String NAME = "Google";
    private static final String AUTH_URL = "https://accounts.google.com/o/oauth2/auth";
    private static final String TOKEN_URL = "https://accounts.google.com/o/oauth2/token";
    private static final String PROFILE_URL = "https://www.googleapis.com/plus/v1/people/me/openIdConnect";
    private static final String DEFAULT_SCOPE = "openid profile email";

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    protected String getScope() {
        return DEFAULT_SCOPE;
    }

    protected String getAuthUrl() {
        return AUTH_URL;
    }

    protected String getTokenUrl() {
        return TOKEN_URL;
    }

    protected SocialUser getProfile(String accessToken) throws SocialProviderException {
        try {
            JSONObject profile = SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken).asJson();
            SocialUser user = new SocialUser(profile.getString("sub"), profile.getString("email"));
            user.setName(profile.optString("given_name"), profile.optString("family_name"));
            user.setEmail(profile.optString("email"));
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }
}

