/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.stackoverflow;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.util.SimpleHttp;
import org.keycloak.broker.provider.FederatedIdentity;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.social.SocialIdentityProvider;
import org.keycloak.social.stackoverflow.StackOverflowIdentityProviderConfig;

public class StackoverflowIdentityProvider
extends AbstractOAuth2IdentityProvider<StackOverflowIdentityProviderConfig>
implements SocialIdentityProvider<StackOverflowIdentityProviderConfig> {
    private static final Logger log = Logger.getLogger(StackoverflowIdentityProvider.class);
    public static final String AUTH_URL = "https://stackexchange.com/oauth";
    public static final String TOKEN_URL = "https://stackexchange.com/oauth/access_token";
    public static final String PROFILE_URL = "https://api.stackexchange.com/2.2/me?order=desc&sort=name&site=stackoverflow";
    public static final String DEFAULT_SCOPE = "";
    private static final String[][] ESCAPES = new String[][]{{"\"", "quot"}, {"&", "amp"}, {"<", "lt"}, {">", "gt"}};
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static final HashMap<String, CharSequence> lookupMap = new HashMap();

    public StackoverflowIdentityProvider(StackOverflowIdentityProviderConfig config) {
        super((OAuth2IdentityProviderConfig)config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    protected FederatedIdentity doGetFederatedIdentity(String accessToken) {
        log.debug((Object)"doGetFederatedIdentity()");
        try {
            String URL = "https://api.stackexchange.com/2.2/me?order=desc&sort=name&site=stackoverflow&access_token=" + accessToken + "&key=" + ((StackOverflowIdentityProviderConfig)this.getConfig()).getKey();
            if (log.isDebugEnabled()) {
                log.debug((Object)("StackOverflow profile request to: " + URL));
            }
            JsonNode profile = SimpleHttp.doGet((String)URL).asJson().get("items").get(0);
            FederatedIdentity user = new FederatedIdentity(this.getJsonProperty(profile, "user_id"));
            user.setUsername(StackoverflowIdentityProvider.extractUsernameFromProfileURL(this.getJsonProperty(profile, "link")));
            user.setName(StackoverflowIdentityProvider.unescapeHtml3(this.getJsonProperty(profile, "display_name")));
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from Stackoverflow: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static String extractUsernameFromProfileURL(String profileURL) {
        if (StackoverflowIdentityProvider.isNotBlank(profileURL)) {
            try {
                log.debug((Object)("go to extract username from profile URL " + profileURL));
                URL u = new URL(profileURL);
                String path = u.getPath();
                if (StackoverflowIdentityProvider.isNotBlank(path) && path.length() > 1) {
                    String[] pe;
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    if ((pe = path.split("/")).length >= 3) {
                        return URLDecoder.decode(pe[2], "UTF-8");
                    }
                    log.warn((Object)("Stackoverflow profile URL path is without third part: " + profileURL));
                } else {
                    log.warn((Object)("Stackoverflow profile URL is without path part: " + profileURL));
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Stackoverflow profile URL is malformed: " + profileURL));
            }
            catch (Exception e) {
                log.warn((Object)("Stackoverflow profile URL " + profileURL + " username extraction failed due: " + e.getMessage()));
            }
        }
        return null;
    }

    private static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }

    public static final String unescapeHtml3(String input) {
        if (input == null) {
            return null;
        }
        StringWriter writer = null;
        int len = input.length();
        int i = 1;
        int st = 0;
        while (true) {
            int j;
            block15: {
                if (i < len && input.charAt(i - 1) != '&') {
                    ++i;
                    continue;
                }
                if (i >= len) break;
                for (j = i; j < len && j < i + 6 + 1 && input.charAt(j) != ';'; ++j) {
                }
                if (j == len || j < i + 2 || j == i + 6 + 1) {
                    ++i;
                    continue;
                }
                if (input.charAt(i) == '#') {
                    int k = i + 1;
                    int radix = 10;
                    char firstChar = input.charAt(k);
                    if (firstChar == 'x' || firstChar == 'X') {
                        ++k;
                        radix = 16;
                    }
                    try {
                        int entityValue = Integer.parseInt(input.substring(k, j), radix);
                        if (writer == null) {
                            writer = new StringWriter(input.length());
                        }
                        writer.append(input.substring(st, i - 1));
                        if (entityValue > 65535) {
                            char[] chrs = Character.toChars(entityValue);
                            writer.write(chrs[0]);
                            writer.write(chrs[1]);
                        } else {
                            writer.write(entityValue);
                        }
                        break block15;
                    }
                    catch (NumberFormatException ex) {
                        ++i;
                        continue;
                    }
                }
                CharSequence value = lookupMap.get(input.substring(i, j));
                if (value == null) {
                    ++i;
                    continue;
                }
                if (writer == null) {
                    writer = new StringWriter(input.length());
                }
                writer.append(input.substring(st, i - 1));
                writer.append(value);
            }
            i = st = j + 1;
        }
        if (writer != null) {
            writer.append(input.substring(st, len));
            return writer.toString();
        }
        return input;
    }

    static {
        for (String[] seq : ESCAPES) {
            lookupMap.put(seq[1].toString(), seq[0]);
        }
    }
}

