/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springboot;

import org.apache.catalina.Valve;
import org.keycloak.adapters.springboot.KeycloakBaseSpringBootConfiguration;
import org.keycloak.adapters.springboot.KeycloakSpringBootConfigResolver;
import org.keycloak.adapters.springboot.KeycloakSpringBootProperties;
import org.keycloak.adapters.tomcat.KeycloakAuthenticatorValve;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={KeycloakSpringBootProperties.class})
@ConditionalOnProperty(value={"keycloak.enabled"}, matchIfMissing=true)
public class KeycloakAutoConfiguration
extends KeycloakBaseSpringBootConfiguration {
    private KeycloakSpringBootProperties keycloakProperties;

    @Autowired
    public void setKeycloakSpringBootProperties(KeycloakSpringBootProperties keycloakProperties, KeycloakSpringBootConfigResolver resolver) {
        this.keycloakProperties = keycloakProperties;
        resolver.setAdapterConfig((AdapterConfig)keycloakProperties);
    }

    @Bean
    public EmbeddedServletContainerCustomizer getKeycloakContainerCustomizer() {
        return new EmbeddedServletContainerCustomizer(){

            public void customize(ConfigurableEmbeddedServletContainer configurableEmbeddedServletContainer) {
                if (configurableEmbeddedServletContainer instanceof TomcatEmbeddedServletContainerFactory) {
                    TomcatEmbeddedServletContainerFactory container = (TomcatEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addContextValves(new Valve[]{new KeycloakAuthenticatorValve()});
                    container.addContextCustomizers(new TomcatContextCustomizer[]{KeycloakAutoConfiguration.this.tomcatKeycloakContextCustomizer()});
                } else if (configurableEmbeddedServletContainer instanceof UndertowEmbeddedServletContainerFactory) {
                    UndertowEmbeddedServletContainerFactory container = (UndertowEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{KeycloakAutoConfiguration.this.undertowKeycloakContextCustomizer()});
                } else if (configurableEmbeddedServletContainer instanceof JettyEmbeddedServletContainerFactory) {
                    JettyEmbeddedServletContainerFactory container = (JettyEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addServerCustomizers(new JettyServerCustomizer[]{KeycloakAutoConfiguration.this.jettyKeycloakServerCustomizer()});
                }
            }
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.eclipse.jetty.webapp.WebAppContext"})
    public JettyServerCustomizer jettyKeycloakServerCustomizer() {
        return new KeycloakJettyServerCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.startup.Tomcat"})
    public TomcatContextCustomizer tomcatKeycloakContextCustomizer() {
        return new KeycloakTomcatContextCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    public UndertowDeploymentInfoCustomizer undertowKeycloakContextCustomizer() {
        return new KeycloakUndertowDeploymentInfoCustomizer(this.keycloakProperties);
    }

    static class KeycloakTomcatContextCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseTomcatContextCustomizer
    implements TomcatContextCustomizer {
        public KeycloakTomcatContextCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }

    static class KeycloakJettyServerCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseJettyServerCustomizer
    implements JettyServerCustomizer {
        public KeycloakJettyServerCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }

    static class KeycloakUndertowDeploymentInfoCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseUndertowDeploymentInfoCustomizer
    implements UndertowDeploymentInfoCustomizer {
        public KeycloakUndertowDeploymentInfoCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }
}

