/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.token;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.adapters.springsecurity.token.SpringSecurityTokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SpringSecurityCookieTokenStore
extends SpringSecurityTokenStore {
    private final Logger logger = LoggerFactory.getLogger(SpringSecurityCookieTokenStore.class);
    private final KeycloakDeployment deployment;
    private final HttpFacade facade;
    private volatile boolean cookieChecked = false;

    public SpringSecurityCookieTokenStore(KeycloakDeployment deployment, HttpServletRequest request, HttpServletResponse response) {
        super(deployment, request);
        Assert.notNull((Object)response, (String)"HttpServletResponse is required");
        this.deployment = deployment;
        this.facade = new SimpleHttpFacade(request, response);
    }

    @Override
    public void checkCurrentToken() {
        KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal = this.checkPrincipalFromCookie();
        if (principal != null) {
            RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
            KeycloakSecurityContext current = ((OIDCHttpFacade)this.facade).getSecurityContext();
            if (current != null) {
                securityContext.setAuthorizationContext(current.getAuthorizationContext());
            }
            Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
            SimpleKeycloakAccount account = new SimpleKeycloakAccount((Principal)principal, roles, securityContext);
            SecurityContextHolder.getContext().setAuthentication((Authentication)new KeycloakAuthenticationToken((KeycloakAccount)account, false));
        } else {
            super.checkCurrentToken();
        }
        this.cookieChecked = true;
    }

    @Override
    public boolean isCached(RequestAuthenticator authenticator) {
        if (!this.cookieChecked) {
            this.checkCurrentToken();
        }
        return super.isCached(authenticator);
    }

    @Override
    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
        super.refreshCallback(securityContext);
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    @Override
    public void saveAccountInfo(OidcKeycloakAccount account) {
        super.saveAccountInfo(account);
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    @Override
    public void logout() {
        CookieTokenStore.removeCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade);
        super.logout();
    }

    private KeycloakPrincipal<RefreshableKeycloakSecurityContext> checkPrincipalFromCookie() {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            this.logger.debug("Account was not in cookie or was invalid");
            return null;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return principal;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            this.refreshCallback(session);
            return principal;
        }
        this.logger.debug("Cleanup and expire cookie for user {} after failed refresh", (Object)principal.getName());
        CookieTokenStore.removeCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade);
        return null;
    }
}

