/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import org.keycloak.federation.sssd.SSSDFederationProvider;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class ReadonlySSSDUserModelDelegate
extends UserModelDelegate
implements UserModel {
    private final SSSDFederationProvider provider;

    public ReadonlySSSDUserModelDelegate(UserModel delegate, SSSDFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void setLastName(String lastName) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void setFirstName(String first) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }

    public void updateCredentialDirectly(UserCredentialValueModel cred) {
        if (cred.getType().equals("password")) {
            throw new IllegalStateException("Federated storage is not writable");
        }
        super.updateCredentialDirectly(cred);
    }

    public void updateCredential(UserCredentialModel cred) {
        if (this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            throw new ModelReadOnlyException("Federated storage is not writable");
        }
        this.delegate.updateCredential(cred);
    }

    public void setEmail(String email) {
        throw new ModelReadOnlyException("Federated storage is not writable");
    }
}

