/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.api;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.freedesktop.sssd.infopipe.User;
import org.jboss.logging.Logger;
import org.keycloak.federation.sssd.api.SSSDException;

public class Sssd {
    private String username;
    private static final Logger logger = Logger.getLogger(Sssd.class);

    public static User user() {
        return SingletonHolder.USER_OBJECT;
    }

    public static InfoPipe infopipe() {
        return SingletonHolder.INFOPIPE_OBJECT;
    }

    public static void disconnect() {
        SingletonHolder.DBUS_CONNECTION.disconnect();
    }

    private Sssd() {
    }

    public Sssd(String username) {
        this.username = username;
    }

    public static String getRawAttribute(Variant variant) {
        Vector value;
        if (variant != null && (value = (Vector)variant.getValue()).size() >= 1) {
            return value.get(0).toString();
        }
        return null;
    }

    public Map<String, Variant> getUserAttributes() {
        String[] attr = new String[]{"mail", "givenname", "sn", "telephoneNumber"};
        Map<String, Variant> attributes = null;
        try {
            InfoPipe infoPipe = Sssd.infopipe();
            attributes = infoPipe.getUserAttributes(this.username, Arrays.asList(attr));
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's attributes. Check if SSSD service is active.");
        }
        return attributes;
    }

    public List<String> getUserGroups() {
        List<String> userGroups;
        try {
            InfoPipe infoPipe = Sssd.infopipe();
            userGroups = infoPipe.getUserGroups(this.username);
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's groups from SSSD. Check if SSSD service is active.");
        }
        return userGroups;
    }

    public static boolean isAvailable() {
        boolean sssdAvailable = false;
        try {
            Path path = Paths.get("/etc/sssd", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", new Object[0]);
            } else {
                sssdAvailable = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"SSSD check failed", (Throwable)e);
        }
        return sssdAvailable;
    }

    private static final class SingletonHolder {
        private static InfoPipe INFOPIPE_OBJECT;
        private static User USER_OBJECT;
        private static DBusConnection DBUS_CONNECTION;

        private SingletonHolder() {
        }

        static {
            try {
                DBUS_CONNECTION = DBusConnection.getConnection(0);
                INFOPIPE_OBJECT = DBUS_CONNECTION.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
                USER_OBJECT = DBUS_CONNECTION.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe/Users", User.class);
            }
            catch (DBusException e) {
                logger.error((Object)"Failed to obtain D-Bus connection", (Throwable)e);
            }
        }
    }
}

