/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.builders;

import java.util.Collections;
import org.keycloak.representations.idm.ClientRepresentation;

public class ClientBuilder {
    private ClientRepresentation rep;

    public static ClientBuilder create(String clientId) {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setEnabled(Boolean.TRUE);
        rep.setClientId(clientId);
        return new ClientBuilder(rep);
    }

    private ClientBuilder(ClientRepresentation rep) {
        this.rep = rep;
    }

    public ClientRepresentation accessType(AccessType accessType) {
        switch (accessType) {
            case BEARER_ONLY: {
                this.rep.setBearerOnly(Boolean.valueOf(true));
                break;
            }
            case PUBLIC: {
                this.rep.setPublicClient(Boolean.valueOf(true));
                break;
            }
            case CONFIDENTIAL: {
                this.rep.setPublicClient(Boolean.valueOf(false));
            }
        }
        return this.defaultSettings();
    }

    public ClientBuilder rootUrl(String rootUrl) {
        this.rep.setRootUrl(rootUrl);
        return this;
    }

    public ClientBuilder redirectUri(String redirectUri) {
        this.rep.setRedirectUris(Collections.singletonList(redirectUri));
        return this;
    }

    public ClientBuilder baseUrl(String baseUrl) {
        this.rep.setBaseUrl(baseUrl);
        return this;
    }

    public ClientBuilder adminUrl(String adminUrl) {
        this.rep.setAdminUrl(adminUrl);
        return this;
    }

    public ClientBuilder secret(String secret) {
        this.rep.setSecret(secret);
        return this;
    }

    private ClientRepresentation defaultSettings() {
        this.rep.setFullScopeAllowed(Boolean.valueOf(true));
        this.rep.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        this.rep.setAdminUrl(this.rep.getRootUrl());
        if (this.rep.getRedirectUris() == null && this.rep.getRootUrl() != null) {
            this.rep.setRedirectUris(Collections.singletonList(this.rep.getRootUrl().concat("/*")));
        }
        return this.rep;
    }

    public static enum AccessType {
        BEARER_ONLY,
        PUBLIC,
        CONFIDENTIAL;

    }
}

