
(function (global) {
  System.config({
    paths: {
      // paths serve as alias
      'npm:': resourceUrl + '/node_modules/'
    },
    // map tells the System loader where to look for things
    map: {
      // our app is within the app folder
      'app': resourceUrl + '/app',
      'resources': resourceUrl,

      'react': 'npm:react/umd/' + reactRuntime,
      'react-dom': 'npm:react-dom/umd/' + reactDOMRuntime,
      'react-router-dom': 'npm:react-router-dom/umd/' + reactRouterRuntime,
      
      '@patternfly/patternfly': 'npm:@patternfly/react-core/dist/umd/@patternfly/patternfly',
      '@patternfly/react-core': 'npm:@patternfly/react-core/dist/umd/index.js',
      '@patternfly/react-styles': 'npm:@patternfly/react-styles/dist/umd/index.js',
      '@patternfly/react-icons': 'npm:@patternfly/react-icons/dist/umd/index.js',
      '@patternfly/react-tokens': 'npm:@patternfly/react-tokens/dist/umd/index.js',
      'emotion': 'npm:emotion/dist/emotion.umd.min.js',
      'camel-case': 'npm:camel-case/camel-case.js',
      'upper-case': 'npm:upper-case/upper-case.js',
      'no-case': 'npm:no-case/no-case.js',
      'lower-case': 'npm:lower-case/lower-case.js',
      'prop-types': 'npm:prop-types/prop-types.min.js',
      'exenv': 'npm:exenv/index.js',
      'focus-trap': 'npm:focus-trap/dist/focus-trap.min.js',
      'focus-trap-react': 'npm:focus-trap-react/dist/focus-trap-react.js',
      '@tippy.js/react': 'npm:@tippy.js/react/dist/Tippy.min.js',
      'tippy.js': 'npm:tippy.js/dist/tippy.min.js',
      
      'moment': 'npm:moment/min/moment-with-locales.min.js',
      
      'axios': 'npm:axios/dist/axios.min.js',
      
      'history': 'npm:history/umd/history.min.js',
    },
    
    bundles: {
        "npm:rxjs-system-bundle/Rx.system.min.js": [
          "rxjs",
          "rxjs/*",
          "rxjs/operator/*",
          "rxjs/observable/*",
          "rxjs/scheduler/*",
          "rxjs/symbol/*",
          "rxjs/add/operator/*",
          "rxjs/add/observable/*",
          "rxjs/util/*"
        ]
      },
      
    // packages tells the System loader how to load when no filename and/or no extension
    packages: {
      app: {
        defaultExtension: 'js',
        meta: {
          './*.js': {
          }
        }
      },
      rxjs: {
        defaultExtension: false
      },
      
      // Components that map to @empty will not be loaded.
      // To load a component, replace @empty with its commented path.
      'npm:@patternfly/react-core/dist/umd/components': {
          main: './index.js',
          defaultExtension: 'js',
          map: {
              './Alert': '@empty', //'./Alert/index.js',
              './AboutModal': '@empty', //'./AboutModal/index.js',
              './ApplicationLauncher': '@empty', //'./ApplicationLauncher/index.js',
              './Avatar': './Avatar/index.js',
              './Backdrop': './Backdrop/index.js',
              './BackgroundImage': './BackgroundImage/index.js',
              './Badge': './Badge/index.js',
              './Brand': './Brand/index.js',
              './Breadcrumb': '@empty', //'./Breadcrumb/index.js',
              './Button': './Button/index.js',
              './Card': './Card/index.js',
              './Card/CardBody': '@empty',
              './Card/CardHeader': '@empty',
              './Card/CardFooter': '@empty',
              './Checkbox': '@empty', //'./Checkbox/index.js',
              './ChipGroup': '@empty', //'./ChipGroup/index.js',
              './ContextSelector': '@empty', //'./ContextSelector/index.js',
              './DataList': '@empty', //'./DataList/index.js',
              './Dropdown': './Dropdown/index.js',
              './EmptyState': '@empty', //'./EmptyState/index.js',
              './Form': '@empty', //'./Form/index.js',
              './FormSelect': '@empty', //'./FormSelect/index.js',
              './InputGroup': '@empty', //'./InputGroup/index.js',
              './Label': '@empty', //'./Label/index.js',
              './List': '@empty', //'./List/index.js',
              './LoginPage': '@empty', //'./LoginPage/index.js',
              './Modal': '@empty', //'./Modal/index.js',
              './Nav': './Nav/index.js',
              './Page': './Page/index.js',
              './Popover': '@empty', //'./Popover/index.js',
              './Progress': '@empty', //'./Progress/index.js',
              './Pagination': '@empty', //'./Pagination/index.js',
              './Radio': '@empty', //'./Radio/index.js',
              './Select': '@empty', //'./Select/index.js',
              './Switch': '@empty', //'./Switch/index.js',
              './Tabs': '@empty', //'./Tabs/index.js',
              './Text': '@empty', //'./Text/index.js',
              './TextArea': '@empty', //'./TextArea/index.js',
              './TextInput': '@empty', //'./TextInput/index.js',
              './Title': '@empty', //'./Title/index.js',
              './Tooltip': '@empty', //'./Tooltip/index.js',
              './Wizard': '@empty', //'./Wizard/index.js',
              './Bullseye': '@empty', //'./Bullseye/index.js',
              './Gallery': '@empty', //'./Gallery/index.js',
              './Grid': '@empty', //'./Grid/index.js',
              './Level': '@empty', //'./Level/index.js',
              './Split': '@empty', //'./Split/index.js',
              './Stack': '@empty', //'./Stack/index.js',
              './Toolbar': '@empty', //'./Toolbar/index.js',
          }
      },
      
      'npm:@patternfly/react-core/dist/umd/styles': {
          main: './index.js',
          defaultExtension: 'js',
      },
      'npm:@patternfly/react-core/dist/umd/helpers': {
          main: './index.js',
          defaultExtension: 'js',
      },
      
      // Layouts that map to @empty will not be loaded.
      // To load a layout, replace @empty with its commented path.
      'npm:@patternfly/react-core/dist/umd/layouts': {
          main: './index.js',
          defaultExtension: 'js',
          map: {
              './Bullseye': './Bullseye/index.js',
              './Gallery': '@empty', //'./Gallery/index.js',
              './Level': '@empty', //'./Level/index.js',
              './Grid': '@empty', //'./Grid/index.js',
              './Stack': '@empty', //'./Stack/index.js',
              './Split': '@empty', //'./Split/index.js',
              './Toolbar': './Toolbar/index.js',
          }
      },
      'npm:@patternfly/react-core/dist/umd/@patternfly/patternfly/utilities/Accessibility': {
          defaultExtension: 'js',
          map: {
             './accessibility.css': './accessibility.css.js'
          }
      },
      'npm:@patternfly/react-styles/dist/umd': {
          defaultExtension: 'js',
      },
      'npm:no-case/vendor': {
          defaultExtension: 'js',
      },
      
      // Icons that map to @empty will not be loaded.
      // To load an icon, just comment out its mapping.
      'npm:@patternfly/react-icons/dist/umd': {
          main: './index.js',
          defaultExtension: 'js',
          map: {
             './icons/ad-icon.js': '@empty',
             './icons/address-book-icon.js': '@empty',
             './icons/address-card-icon.js': '@empty',
             './icons/adjust-icon.js': '@empty',
             './icons/air-freshener-icon.js': '@empty',
             './icons/align-center-icon.js': '@empty',
             './icons/align-justify-icon.js': '@empty',
             './icons/align-left-icon.js': '@empty',
             './icons/align-right-icon.js': '@empty',
             './icons/allergies-icon.js': '@empty',
             './icons/ambulance-icon.js': '@empty',
             './icons/american-sign-language-interpreting-icon.js': '@empty',
             './icons/anchor-icon.js': '@empty',
             './icons/angle-double-down-icon.js': '@empty',
             './icons/angle-double-left-icon.js': '@empty',
             './icons/angle-double-right-icon.js': '@empty',
             './icons/angle-double-up-icon.js': '@empty',
             //'./icons/angle-down-icon.js': '@empty',
             './icons/angle-left-icon.js': '@empty',
             //'./icons/angle-right-icon.js': '@empty',
             './icons/angle-up-icon.js': '@empty',
             './icons/angry-icon.js': '@empty',
             './icons/ankh-icon.js': '@empty',
             './icons/apple-alt-icon.js': '@empty',
             './icons/archive-icon.js': '@empty',
             './icons/archway-icon.js': '@empty',
             './icons/arrow-alt-circle-down-icon.js': '@empty',
             './icons/arrow-alt-circle-left-icon.js': '@empty',
             './icons/arrow-alt-circle-right-icon.js': '@empty',
             './icons/arrow-alt-circle-up-icon.js': '@empty',
             './icons/arrow-circle-down-icon.js': '@empty',
             './icons/arrow-circle-left-icon.js': '@empty',
             './icons/arrow-circle-right-icon.js': '@empty',
             './icons/arrow-circle-up-icon.js': '@empty',
             './icons/arrow-down-icon.js': '@empty',
             './icons/arrow-left-icon.js': '@empty',
             './icons/arrow-right-icon.js': '@empty',
             './icons/arrow-up-icon.js': '@empty',
             './icons/arrows-alt-icon.js': '@empty',
             './icons/arrows-alt-h-icon.js': '@empty',
             './icons/arrows-alt-v-icon.js': '@empty',
             './icons/assistive-listening-systems-icon.js': '@empty',
             './icons/asterisk-icon.js': '@empty',
             './icons/at-icon.js': '@empty',
             './icons/atlas-icon.js': '@empty',
             './icons/atom-icon.js': '@empty',
             './icons/audio-description-icon.js': '@empty',
             './icons/award-icon.js': '@empty',
             './icons/baby-icon.js': '@empty',
             './icons/baby-carriage-icon.js': '@empty',
             './icons/backspace-icon.js': '@empty',
             './icons/backward-icon.js': '@empty',
             './icons/bacon-icon.js': '@empty',
             './icons/balance-scale-icon.js': '@empty',
             './icons/ban-icon.js': '@empty',
             './icons/band-aid-icon.js': '@empty',
             './icons/barcode-icon.js': '@empty',
             //'./icons/bars-icon.js': '@empty',
             './icons/baseball-ball-icon.js': '@empty',
             './icons/basketball-ball-icon.js': '@empty',
             './icons/bath-icon.js': '@empty',
             './icons/battery-empty-icon.js': '@empty',
             './icons/battery-full-icon.js': '@empty',
             './icons/battery-half-icon.js': '@empty',
             './icons/battery-quarter-icon.js': '@empty',
             './icons/battery-three-quarters-icon.js': '@empty',
             './icons/bed-icon.js': '@empty',
             './icons/beer-icon.js': '@empty',
             './icons/bell-icon.js': '@empty',
             './icons/bell-slash-icon.js': '@empty',
             './icons/bezier-curve-icon.js': '@empty',
             './icons/bible-icon.js': '@empty',
             './icons/bicycle-icon.js': '@empty',
             './icons/binoculars-icon.js': '@empty',
             './icons/biohazard-icon.js': '@empty',
             './icons/birthday-cake-icon.js': '@empty',
             './icons/blender-icon.js': '@empty',
             './icons/blender-phone-icon.js': '@empty',
             './icons/blind-icon.js': '@empty',
             './icons/blog-icon.js': '@empty',
             './icons/bold-icon.js': '@empty',
             './icons/bolt-icon.js': '@empty',
             './icons/bomb-icon.js': '@empty',
             './icons/bone-icon.js': '@empty',
             './icons/bong-icon.js': '@empty',
             './icons/book-icon.js': '@empty',
             './icons/book-dead-icon.js': '@empty',
             './icons/book-medical-icon.js': '@empty',
             './icons/book-open-icon.js': '@empty',
             './icons/book-reader-icon.js': '@empty',
             './icons/bookmark-icon.js': '@empty',
             './icons/bowling-ball-icon.js': '@empty',
             './icons/box-icon.js': '@empty',
             './icons/box-open-icon.js': '@empty',
             './icons/boxes-icon.js': '@empty',
             './icons/braille-icon.js': '@empty',
             './icons/brain-icon.js': '@empty',
             './icons/bread-slice-icon.js': '@empty',
             './icons/briefcase-icon.js': '@empty',
             './icons/briefcase-medical-icon.js': '@empty',
             './icons/broadcast-tower-icon.js': '@empty',
             './icons/broom-icon.js': '@empty',
             './icons/brush-icon.js': '@empty',
             './icons/bug-icon.js': '@empty',
             './icons/building-icon.js': '@empty',
             './icons/bullhorn-icon.js': '@empty',
             './icons/bullseye-icon.js': '@empty',
             './icons/burn-icon.js': '@empty',
             './icons/bus-icon.js': '@empty',
             './icons/bus-alt-icon.js': '@empty',
             './icons/business-time-icon.js': '@empty',
             './icons/calculator-icon.js': '@empty',
             './icons/calendar-icon.js': '@empty',
             './icons/calendar-alt-icon.js': '@empty',
             './icons/calendar-check-icon.js': '@empty',
             './icons/calendar-day-icon.js': '@empty',
             './icons/calendar-minus-icon.js': '@empty',
             './icons/calendar-plus-icon.js': '@empty',
             './icons/calendar-times-icon.js': '@empty',
             './icons/calendar-week-icon.js': '@empty',
             './icons/camera-icon.js': '@empty',
             './icons/camera-retro-icon.js': '@empty',
             './icons/campground-icon.js': '@empty',
             './icons/candy-cane-icon.js': '@empty',
             './icons/cannabis-icon.js': '@empty',
             './icons/capsules-icon.js': '@empty',
             './icons/car-icon.js': '@empty',
             './icons/car-alt-icon.js': '@empty',
             './icons/car-battery-icon.js': '@empty',
             './icons/car-crash-icon.js': '@empty',
             './icons/car-side-icon.js': '@empty',
             //'./icons/caret-down-icon.js': '@empty',
             './icons/caret-left-icon.js': '@empty',
             './icons/caret-right-icon.js': '@empty',
             './icons/caret-square-down-icon.js': '@empty',
             './icons/caret-square-left-icon.js': '@empty',
             './icons/caret-square-right-icon.js': '@empty',
             './icons/caret-square-up-icon.js': '@empty',
             './icons/caret-up-icon.js': '@empty',
             './icons/carrot-icon.js': '@empty',
             './icons/cart-arrow-down-icon.js': '@empty',
             './icons/cart-plus-icon.js': '@empty',
             './icons/cash-register-icon.js': '@empty',
             './icons/cat-icon.js': '@empty',
             './icons/certificate-icon.js': '@empty',
             './icons/chair-icon.js': '@empty',
             './icons/chalkboard-icon.js': '@empty',
             './icons/chalkboard-teacher-icon.js': '@empty',
             './icons/charging-station-icon.js': '@empty',
             './icons/chart-area-icon.js': '@empty',
             './icons/chart-bar-icon.js': '@empty',
             './icons/chart-line-icon.js': '@empty',
             './icons/chart-pie-icon.js': '@empty',
             './icons/check-icon.js': '@empty',
             './icons/check-circle-icon.js': '@empty',
             './icons/check-double-icon.js': '@empty',
             './icons/check-square-icon.js': '@empty',
             './icons/cheese-icon.js': '@empty',
             './icons/chess-icon.js': '@empty',
             './icons/chess-bishop-icon.js': '@empty',
             './icons/chess-board-icon.js': '@empty',
             './icons/chess-king-icon.js': '@empty',
             './icons/chess-knight-icon.js': '@empty',
             './icons/chess-pawn-icon.js': '@empty',
             './icons/chess-queen-icon.js': '@empty',
             './icons/chess-rook-icon.js': '@empty',
             './icons/chevron-circle-down-icon.js': '@empty',
             './icons/chevron-circle-left-icon.js': '@empty',
             './icons/chevron-circle-right-icon.js': '@empty',
             './icons/chevron-circle-up-icon.js': '@empty',
             './icons/chevron-down-icon.js': '@empty',
             './icons/chevron-left-icon.js': '@empty',
             './icons/chevron-right-icon.js': '@empty',
             './icons/chevron-up-icon.js': '@empty',
             './icons/child-icon.js': '@empty',
             './icons/church-icon.js': '@empty',
             './icons/circle-icon.js': '@empty',
             './icons/circle-notch-icon.js': '@empty',
             './icons/city-icon.js': '@empty',
             './icons/clinic-medical-icon.js': '@empty',
             './icons/clipboard-icon.js': '@empty',
             './icons/clipboard-check-icon.js': '@empty',
             './icons/clipboard-list-icon.js': '@empty',
             './icons/clock-icon.js': '@empty',
             './icons/clone-icon.js': '@empty',
             './icons/closed-captioning-icon.js': '@empty',
             './icons/cloud-icon.js': '@empty',
             './icons/cloud-download-alt-icon.js': '@empty',
             './icons/cloud-meatball-icon.js': '@empty',
             './icons/cloud-moon-icon.js': '@empty',
             './icons/cloud-moon-rain-icon.js': '@empty',
             './icons/cloud-rain-icon.js': '@empty',
             './icons/cloud-showers-heavy-icon.js': '@empty',
             './icons/cloud-sun-icon.js': '@empty',
             './icons/cloud-sun-rain-icon.js': '@empty',
             './icons/cloud-upload-alt-icon.js': '@empty',
             './icons/cocktail-icon.js': '@empty',
             './icons/code-icon.js': '@empty',
             './icons/code-branch-icon.js': '@empty',
             './icons/coffee-icon.js': '@empty',
             './icons/cog-icon.js': '@empty',
             './icons/cogs-icon.js': '@empty',
             './icons/coins-icon.js': '@empty',
             './icons/columns-icon.js': '@empty',
             './icons/comment-icon.js': '@empty',
             './icons/comment-alt-icon.js': '@empty',
             './icons/comment-dollar-icon.js': '@empty',
             './icons/comment-dots-icon.js': '@empty',
             './icons/comment-medical-icon.js': '@empty',
             './icons/comment-slash-icon.js': '@empty',
             './icons/comments-icon.js': '@empty',
             './icons/comments-dollar-icon.js': '@empty',
             './icons/compact-disc-icon.js': '@empty',
             './icons/compass-icon.js': '@empty',
             './icons/compress-icon.js': '@empty',
             './icons/compress-arrows-alt-icon.js': '@empty',
             './icons/concierge-bell-icon.js': '@empty',
             './icons/cookie-icon.js': '@empty',
             './icons/cookie-bite-icon.js': '@empty',
             './icons/copy-icon.js': '@empty',
             './icons/copyright-icon.js': '@empty',
             './icons/couch-icon.js': '@empty',
             './icons/credit-card-icon.js': '@empty',
             './icons/crop-icon.js': '@empty',
             './icons/crop-alt-icon.js': '@empty',
             './icons/cross-icon.js': '@empty',
             './icons/crosshairs-icon.js': '@empty',
             './icons/crow-icon.js': '@empty',
             './icons/crown-icon.js': '@empty',
             './icons/crutch-icon.js': '@empty',
             './icons/cube-icon.js': '@empty',
             './icons/cubes-icon.js': '@empty',
             './icons/cut-icon.js': '@empty',
             './icons/database-icon.js': '@empty',
             './icons/deaf-icon.js': '@empty',
             './icons/democrat-icon.js': '@empty',
             './icons/desktop-icon.js': '@empty',
             './icons/dharmachakra-icon.js': '@empty',
             './icons/diagnoses-icon.js': '@empty',
             './icons/dice-icon.js': '@empty',
             './icons/dice-d20-icon.js': '@empty',
             './icons/dice-d6-icon.js': '@empty',
             './icons/dice-five-icon.js': '@empty',
             './icons/dice-four-icon.js': '@empty',
             './icons/dice-one-icon.js': '@empty',
             './icons/dice-six-icon.js': '@empty',
             './icons/dice-three-icon.js': '@empty',
             './icons/dice-two-icon.js': '@empty',
             './icons/digital-tachograph-icon.js': '@empty',
             './icons/directions-icon.js': '@empty',
             './icons/divide-icon.js': '@empty',
             './icons/dizzy-icon.js': '@empty',
             './icons/dna-icon.js': '@empty',
             './icons/dog-icon.js': '@empty',
             './icons/dollar-sign-icon.js': '@empty',
             './icons/dolly-icon.js': '@empty',
             './icons/dolly-flatbed-icon.js': '@empty',
             './icons/donate-icon.js': '@empty',
             './icons/door-closed-icon.js': '@empty',
             './icons/door-open-icon.js': '@empty',
             './icons/dot-circle-icon.js': '@empty',
             './icons/dove-icon.js': '@empty',
             './icons/download-icon.js': '@empty',
             './icons/drafting-compass-icon.js': '@empty',
             './icons/dragon-icon.js': '@empty',
             './icons/draw-polygon-icon.js': '@empty',
             './icons/drum-icon.js': '@empty',
             './icons/drum-steelpan-icon.js': '@empty',
             './icons/drumstick-bite-icon.js': '@empty',
             './icons/dumbbell-icon.js': '@empty',
             './icons/dumpster-icon.js': '@empty',
             './icons/dumpster-fire-icon.js': '@empty',
             './icons/dungeon-icon.js': '@empty',
             './icons/edit-icon.js': '@empty',
             './icons/egg-icon.js': '@empty',
             './icons/eject-icon.js': '@empty',
             './icons/ellipsis-h-icon.js': '@empty',
             //'./icons/ellipsis-v-icon.js': '@empty',
             './icons/envelope-icon.js': '@empty',
             './icons/envelope-open-icon.js': '@empty',
             './icons/envelope-open-text-icon.js': '@empty',
             './icons/envelope-square-icon.js': '@empty',
             './icons/equals-icon.js': '@empty',
             './icons/eraser-icon.js': '@empty',
             './icons/ethernet-icon.js': '@empty',
             './icons/euro-sign-icon.js': '@empty',
             './icons/exchange-alt-icon.js': '@empty',
             './icons/exclamation-icon.js': '@empty',
             './icons/exclamation-circle-icon.js': '@empty',
             './icons/exclamation-triangle-icon.js': '@empty',
             './icons/expand-icon.js': '@empty',
             './icons/expand-arrows-alt-icon.js': '@empty',
             './icons/external-link-alt-icon.js': '@empty',
             './icons/external-link-square-alt-icon.js': '@empty',
             './icons/eye-icon.js': '@empty',
             './icons/eye-dropper-icon.js': '@empty',
             './icons/eye-slash-icon.js': '@empty',
             './icons/fast-backward-icon.js': '@empty',
             './icons/fast-forward-icon.js': '@empty',
             './icons/fax-icon.js': '@empty',
             './icons/feather-icon.js': '@empty',
             './icons/feather-alt-icon.js': '@empty',
             './icons/female-icon.js': '@empty',
             './icons/fighter-jet-icon.js': '@empty',
             './icons/file-icon.js': '@empty',
             './icons/file-alt-icon.js': '@empty',
             './icons/file-archive-icon.js': '@empty',
             './icons/file-audio-icon.js': '@empty',
             './icons/file-code-icon.js': '@empty',
             './icons/file-contract-icon.js': '@empty',
             './icons/file-csv-icon.js': '@empty',
             './icons/file-download-icon.js': '@empty',
             './icons/file-excel-icon.js': '@empty',
             './icons/file-export-icon.js': '@empty',
             './icons/file-image-icon.js': '@empty',
             './icons/file-import-icon.js': '@empty',
             './icons/file-invoice-icon.js': '@empty',
             './icons/file-invoice-dollar-icon.js': '@empty',
             './icons/file-medical-icon.js': '@empty',
             './icons/file-medical-alt-icon.js': '@empty',
             './icons/file-pdf-icon.js': '@empty',
             './icons/file-powerpoint-icon.js': '@empty',
             './icons/file-prescription-icon.js': '@empty',
             './icons/file-signature-icon.js': '@empty',
             './icons/file-upload-icon.js': '@empty',
             './icons/file-video-icon.js': '@empty',
             './icons/file-word-icon.js': '@empty',
             './icons/fill-icon.js': '@empty',
             './icons/fill-drip-icon.js': '@empty',
             './icons/film-icon.js': '@empty',
             './icons/filter-icon.js': '@empty',
             './icons/fingerprint-icon.js': '@empty',
             './icons/fire-icon.js': '@empty',
             './icons/fire-alt-icon.js': '@empty',
             './icons/fire-extinguisher-icon.js': '@empty',
             './icons/first-aid-icon.js': '@empty',
             './icons/fish-icon.js': '@empty',
             './icons/fist-raised-icon.js': '@empty',
             './icons/flag-icon.js': '@empty',
             './icons/flag-checkered-icon.js': '@empty',
             './icons/flag-usa-icon.js': '@empty',
             './icons/flask-icon.js': '@empty',
             './icons/flushed-icon.js': '@empty',
             './icons/folder-icon.js': '@empty',
             './icons/folder-minus-icon.js': '@empty',
             './icons/folder-open-icon.js': '@empty',
             './icons/folder-plus-icon.js': '@empty',
             './icons/font-icon.js': '@empty',
             './icons/font-awesome-logo-full-icon.js': '@empty',
             './icons/football-ball-icon.js': '@empty',
             './icons/forward-icon.js': '@empty',
             './icons/frog-icon.js': '@empty',
             './icons/frown-icon.js': '@empty',
             './icons/frown-open-icon.js': '@empty',
             './icons/funnel-dollar-icon.js': '@empty',
             './icons/futbol-icon.js': '@empty',
             './icons/gamepad-icon.js': '@empty',
             './icons/gas-pump-icon.js': '@empty',
             './icons/gavel-icon.js': '@empty',
             './icons/gem-icon.js': '@empty',
             './icons/genderless-icon.js': '@empty',
             './icons/ghost-icon.js': '@empty',
             './icons/gift-icon.js': '@empty',
             './icons/gifts-icon.js': '@empty',
             './icons/glass-cheers-icon.js': '@empty',
             './icons/glass-martini-icon.js': '@empty',
             './icons/glass-martini-alt-icon.js': '@empty',
             './icons/glass-whiskey-icon.js': '@empty',
             './icons/glasses-icon.js': '@empty',
             './icons/globe-icon.js': '@empty',
             './icons/globe-africa-icon.js': '@empty',
             './icons/globe-americas-icon.js': '@empty',
             './icons/globe-asia-icon.js': '@empty',
             './icons/globe-europe-icon.js': '@empty',
             './icons/golf-ball-icon.js': '@empty',
             './icons/gopuram-icon.js': '@empty',
             './icons/graduation-cap-icon.js': '@empty',
             './icons/greater-than-icon.js': '@empty',
             './icons/greater-than-equal-icon.js': '@empty',
             './icons/grimace-icon.js': '@empty',
             './icons/grin-icon.js': '@empty',
             './icons/grin-alt-icon.js': '@empty',
             './icons/grin-beam-icon.js': '@empty',
             './icons/grin-beam-sweat-icon.js': '@empty',
             './icons/grin-hearts-icon.js': '@empty',
             './icons/grin-squint-icon.js': '@empty',
             './icons/grin-squint-tears-icon.js': '@empty',
             './icons/grin-stars-icon.js': '@empty',
             './icons/grin-tears-icon.js': '@empty',
             './icons/grin-tongue-icon.js': '@empty',
             './icons/grin-tongue-squint-icon.js': '@empty',
             './icons/grin-tongue-wink-icon.js': '@empty',
             './icons/grin-wink-icon.js': '@empty',
             './icons/grip-horizontal-icon.js': '@empty',
             './icons/grip-lines-icon.js': '@empty',
             './icons/grip-lines-vertical-icon.js': '@empty',
             './icons/grip-vertical-icon.js': '@empty',
             './icons/guitar-icon.js': '@empty',
             './icons/h-square-icon.js': '@empty',
             './icons/hamburger-icon.js': '@empty',
             './icons/hammer-icon.js': '@empty',
             './icons/hamsa-icon.js': '@empty',
             './icons/hand-holding-icon.js': '@empty',
             './icons/hand-holding-heart-icon.js': '@empty',
             './icons/hand-holding-usd-icon.js': '@empty',
             './icons/hand-lizard-icon.js': '@empty',
             './icons/hand-middle-finger-icon.js': '@empty',
             './icons/hand-paper-icon.js': '@empty',
             './icons/hand-peace-icon.js': '@empty',
             './icons/hand-point-down-icon.js': '@empty',
             './icons/hand-point-left-icon.js': '@empty',
             './icons/hand-point-right-icon.js': '@empty',
             './icons/hand-point-up-icon.js': '@empty',
             './icons/hand-pointer-icon.js': '@empty',
             './icons/hand-rock-icon.js': '@empty',
             './icons/hand-scissors-icon.js': '@empty',
             './icons/hand-spock-icon.js': '@empty',
             './icons/hands-icon.js': '@empty',
             './icons/hands-helping-icon.js': '@empty',
             './icons/handshake-icon.js': '@empty',
             './icons/hanukiah-icon.js': '@empty',
             './icons/hard-hat-icon.js': '@empty',
             './icons/hashtag-icon.js': '@empty',
             './icons/hat-wizard-icon.js': '@empty',
             './icons/haykal-icon.js': '@empty',
             './icons/hdd-icon.js': '@empty',
             './icons/heading-icon.js': '@empty',
             './icons/headphones-icon.js': '@empty',
             './icons/headphones-alt-icon.js': '@empty',
             './icons/headset-icon.js': '@empty',
             './icons/heart-icon.js': '@empty',
             './icons/heart-broken-icon.js': '@empty',
             './icons/heartbeat-icon.js': '@empty',
             './icons/helicopter-icon.js': '@empty',
             './icons/highlighter-icon.js': '@empty',
             './icons/hiking-icon.js': '@empty',
             './icons/hippo-icon.js': '@empty',
             './icons/history-icon.js': '@empty',
             './icons/hockey-puck-icon.js': '@empty',
             './icons/holly-berry-icon.js': '@empty',
             './icons/home-icon.js': '@empty',
             './icons/horse-icon.js': '@empty',
             './icons/horse-head-icon.js': '@empty',
             './icons/hospital-icon.js': '@empty',
             './icons/hospital-alt-icon.js': '@empty',
             './icons/hospital-symbol-icon.js': '@empty',
             './icons/hot-tub-icon.js': '@empty',
             './icons/hotdog-icon.js': '@empty',
             './icons/hotel-icon.js': '@empty',
             './icons/hourglass-icon.js': '@empty',
             './icons/hourglass-end-icon.js': '@empty',
             './icons/hourglass-half-icon.js': '@empty',
             './icons/hourglass-start-icon.js': '@empty',
             './icons/house-damage-icon.js': '@empty',
             './icons/hryvnia-icon.js': '@empty',
             './icons/i-cursor-icon.js': '@empty',
             './icons/ice-cream-icon.js': '@empty',
             './icons/icicles-icon.js': '@empty',
             './icons/id-badge-icon.js': '@empty',
             './icons/id-card-icon.js': '@empty',
             './icons/id-card-alt-icon.js': '@empty',
             './icons/igloo-icon.js': '@empty',
             './icons/image-icon.js': '@empty',
             './icons/images-icon.js': '@empty',
             './icons/inbox-icon.js': '@empty',
             './icons/indent-icon.js': '@empty',
             './icons/industry-icon.js': '@empty',
             './icons/infinity-icon.js': '@empty',
             './icons/info-icon.js': '@empty',
             './icons/info-circle-icon.js': '@empty',
             './icons/italic-icon.js': '@empty',
             './icons/jedi-icon.js': '@empty',
             './icons/joint-icon.js': '@empty',
             './icons/journal-whills-icon.js': '@empty',
             './icons/kaaba-icon.js': '@empty',
             './icons/key-icon.js': '@empty',
             './icons/keyboard-icon.js': '@empty',
             './icons/khanda-icon.js': '@empty',
             './icons/kiss-icon.js': '@empty',
             './icons/kiss-beam-icon.js': '@empty',
             './icons/kiss-wink-heart-icon.js': '@empty',
             './icons/kiwi-bird-icon.js': '@empty',
             './icons/landmark-icon.js': '@empty',
             './icons/language-icon.js': '@empty',
             './icons/laptop-icon.js': '@empty',
             './icons/laptop-code-icon.js': '@empty',
             './icons/laptop-medical-icon.js': '@empty',
             './icons/laugh-icon.js': '@empty',
             './icons/laugh-beam-icon.js': '@empty',
             './icons/laugh-squint-icon.js': '@empty',
             './icons/laugh-wink-icon.js': '@empty',
             './icons/layer-group-icon.js': '@empty',
             './icons/leaf-icon.js': '@empty',
             './icons/lemon-icon.js': '@empty',
             './icons/less-than-icon.js': '@empty',
             './icons/less-than-equal-icon.js': '@empty',
             './icons/level-down-alt-icon.js': '@empty',
             './icons/level-up-alt-icon.js': '@empty',
             './icons/life-ring-icon.js': '@empty',
             './icons/lightbulb-icon.js': '@empty',
             './icons/link-icon.js': '@empty',
             './icons/lira-sign-icon.js': '@empty',
             './icons/list-icon.js': '@empty',
             './icons/list-alt-icon.js': '@empty',
             './icons/list-ol-icon.js': '@empty',
             './icons/list-ul-icon.js': '@empty',
             './icons/location-arrow-icon.js': '@empty',
             './icons/lock-icon.js': '@empty',
             './icons/lock-open-icon.js': '@empty',
             './icons/long-arrow-alt-down-icon.js': '@empty',
             './icons/long-arrow-alt-left-icon.js': '@empty',
             './icons/long-arrow-alt-right-icon.js': '@empty',
             './icons/long-arrow-alt-up-icon.js': '@empty',
             './icons/low-vision-icon.js': '@empty',
             './icons/luggage-cart-icon.js': '@empty',
             './icons/magic-icon.js': '@empty',
             './icons/magnet-icon.js': '@empty',
             './icons/mail-bulk-icon.js': '@empty',
             './icons/male-icon.js': '@empty',
             './icons/map-icon.js': '@empty',
             './icons/map-marked-icon.js': '@empty',
             './icons/map-marked-alt-icon.js': '@empty',
             './icons/map-marker-icon.js': '@empty',
             './icons/map-marker-alt-icon.js': '@empty',
             './icons/map-pin-icon.js': '@empty',
             './icons/map-signs-icon.js': '@empty',
             './icons/marker-icon.js': '@empty',
             './icons/mars-icon.js': '@empty',
             './icons/mars-double-icon.js': '@empty',
             './icons/mars-stroke-icon.js': '@empty',
             './icons/mars-stroke-h-icon.js': '@empty',
             './icons/mars-stroke-v-icon.js': '@empty',
             './icons/mask-icon.js': '@empty',
             './icons/medal-icon.js': '@empty',
             './icons/medkit-icon.js': '@empty',
             './icons/meh-icon.js': '@empty',
             './icons/meh-blank-icon.js': '@empty',
             './icons/meh-rolling-eyes-icon.js': '@empty',
             './icons/memory-icon.js': '@empty',
             './icons/menorah-icon.js': '@empty',
             './icons/mercury-icon.js': '@empty',
             './icons/meteor-icon.js': '@empty',
             './icons/microchip-icon.js': '@empty',
             './icons/microphone-icon.js': '@empty',
             './icons/microphone-alt-icon.js': '@empty',
             './icons/microphone-alt-slash-icon.js': '@empty',
             './icons/microphone-slash-icon.js': '@empty',
             './icons/microscope-icon.js': '@empty',
             './icons/minus-icon.js': '@empty',
             './icons/minus-circle-icon.js': '@empty',
             './icons/minus-square-icon.js': '@empty',
             './icons/mitten-icon.js': '@empty',
             './icons/mobile-icon.js': '@empty',
             './icons/mobile-alt-icon.js': '@empty',
             './icons/money-bill-icon.js': '@empty',
             './icons/money-bill-alt-icon.js': '@empty',
             './icons/money-bill-wave-icon.js': '@empty',
             './icons/money-bill-wave-alt-icon.js': '@empty',
             './icons/money-check-icon.js': '@empty',
             './icons/money-check-alt-icon.js': '@empty',
             './icons/monument-icon.js': '@empty',
             './icons/moon-icon.js': '@empty',
             './icons/mortar-pestle-icon.js': '@empty',
             './icons/mosque-icon.js': '@empty',
             './icons/motorcycle-icon.js': '@empty',
             './icons/mountain-icon.js': '@empty',
             './icons/mouse-pointer-icon.js': '@empty',
             './icons/mug-hot-icon.js': '@empty',
             './icons/music-icon.js': '@empty',
             './icons/network-wired-icon.js': '@empty',
             './icons/neuter-icon.js': '@empty',
             './icons/newspaper-icon.js': '@empty',
             './icons/not-equal-icon.js': '@empty',
             './icons/notes-medical-icon.js': '@empty',
             './icons/object-group-icon.js': '@empty',
             './icons/object-ungroup-icon.js': '@empty',
             './icons/oil-can-icon.js': '@empty',
             './icons/om-icon.js': '@empty',
             './icons/otter-icon.js': '@empty',
             './icons/outdent-icon.js': '@empty',
             './icons/pager-icon.js': '@empty',
             './icons/paint-brush-icon.js': '@empty',
             './icons/paint-roller-icon.js': '@empty',
             './icons/palette-icon.js': '@empty',
             './icons/pallet-icon.js': '@empty',
             './icons/paper-plane-icon.js': '@empty',
             './icons/paperclip-icon.js': '@empty',
             './icons/parachute-box-icon.js': '@empty',
             './icons/paragraph-icon.js': '@empty',
             './icons/parking-icon.js': '@empty',
             './icons/passport-icon.js': '@empty',
             './icons/pastafarianism-icon.js': '@empty',
             './icons/paste-icon.js': '@empty',
             './icons/pause-icon.js': '@empty',
             './icons/pause-circle-icon.js': '@empty',
             './icons/paw-icon.js': '@empty',
             './icons/peace-icon.js': '@empty',
             './icons/pen-icon.js': '@empty',
             './icons/pen-alt-icon.js': '@empty',
             './icons/pen-fancy-icon.js': '@empty',
             './icons/pen-nib-icon.js': '@empty',
             './icons/pen-square-icon.js': '@empty',
             './icons/pencil-alt-icon.js': '@empty',
             './icons/pencil-ruler-icon.js': '@empty',
             './icons/people-carry-icon.js': '@empty',
             './icons/pepper-hot-icon.js': '@empty',
             './icons/percent-icon.js': '@empty',
             './icons/percentage-icon.js': '@empty',
             './icons/person-booth-icon.js': '@empty',
             './icons/phone-icon.js': '@empty',
             './icons/phone-slash-icon.js': '@empty',
             './icons/phone-square-icon.js': '@empty',
             './icons/phone-volume-icon.js': '@empty',
             './icons/piggy-bank-icon.js': '@empty',
             './icons/pills-icon.js': '@empty',
             './icons/pizza-slice-icon.js': '@empty',
             './icons/place-of-worship-icon.js': '@empty',
             './icons/plane-icon.js': '@empty',
             './icons/plane-arrival-icon.js': '@empty',
             './icons/plane-departure-icon.js': '@empty',
             './icons/play-icon.js': '@empty',
             './icons/play-circle-icon.js': '@empty',
             './icons/plug-icon.js': '@empty',
             './icons/plus-icon.js': '@empty',
             './icons/plus-circle-icon.js': '@empty',
             './icons/plus-square-icon.js': '@empty',
             './icons/podcast-icon.js': '@empty',
             './icons/poll-icon.js': '@empty',
             './icons/poll-h-icon.js': '@empty',
             './icons/poo-icon.js': '@empty',
             './icons/poo-storm-icon.js': '@empty',
             './icons/poop-icon.js': '@empty',
             './icons/portrait-icon.js': '@empty',
             './icons/pound-sign-icon.js': '@empty',
             './icons/power-off-icon.js': '@empty',
             './icons/pray-icon.js': '@empty',
             './icons/praying-hands-icon.js': '@empty',
             './icons/prescription-icon.js': '@empty',
             './icons/prescription-bottle-icon.js': '@empty',
             './icons/prescription-bottle-alt-icon.js': '@empty',
             './icons/print-icon.js': '@empty',
             './icons/procedures-icon.js': '@empty',
             './icons/project-diagram-icon.js': '@empty',
             './icons/puzzle-piece-icon.js': '@empty',
             './icons/qrcode-icon.js': '@empty',
             './icons/question-icon.js': '@empty',
             './icons/question-circle-icon.js': '@empty',
             './icons/quidditch-icon.js': '@empty',
             './icons/quote-left-icon.js': '@empty',
             './icons/quote-right-icon.js': '@empty',
             './icons/quran-icon.js': '@empty',
             './icons/radiation-icon.js': '@empty',
             './icons/radiation-alt-icon.js': '@empty',
             './icons/rainbow-icon.js': '@empty',
             './icons/random-icon.js': '@empty',
             './icons/receipt-icon.js': '@empty',
             './icons/recycle-icon.js': '@empty',
             './icons/redo-icon.js': '@empty',
             './icons/redo-alt-icon.js': '@empty',
             './icons/registered-icon.js': '@empty',
             './icons/reply-icon.js': '@empty',
             './icons/reply-all-icon.js': '@empty',
             './icons/republican-icon.js': '@empty',
             './icons/restroom-icon.js': '@empty',
             './icons/retweet-icon.js': '@empty',
             './icons/ribbon-icon.js': '@empty',
             './icons/ring-icon.js': '@empty',
             './icons/road-icon.js': '@empty',
             './icons/robot-icon.js': '@empty',
             './icons/rocket-icon.js': '@empty',
             './icons/route-icon.js': '@empty',
             './icons/rss-icon.js': '@empty',
             './icons/rss-square-icon.js': '@empty',
             './icons/ruble-sign-icon.js': '@empty',
             './icons/ruler-icon.js': '@empty',
             './icons/ruler-combined-icon.js': '@empty',
             './icons/ruler-horizontal-icon.js': '@empty',
             './icons/ruler-vertical-icon.js': '@empty',
             './icons/running-icon.js': '@empty',
             './icons/rupee-sign-icon.js': '@empty',
             './icons/sad-cry-icon.js': '@empty',
             './icons/sad-tear-icon.js': '@empty',
             './icons/satellite-icon.js': '@empty',
             './icons/satellite-dish-icon.js': '@empty',
             './icons/save-icon.js': '@empty',
             './icons/school-icon.js': '@empty',
             './icons/screwdriver-icon.js': '@empty',
             './icons/scroll-icon.js': '@empty',
             './icons/sd-card-icon.js': '@empty',
             './icons/search-icon.js': '@empty',
             './icons/search-dollar-icon.js': '@empty',
             './icons/search-location-icon.js': '@empty',
             './icons/search-minus-icon.js': '@empty',
             './icons/search-plus-icon.js': '@empty',
             './icons/seedling-icon.js': '@empty',
             './icons/server-icon.js': '@empty',
             './icons/shapes-icon.js': '@empty',
             './icons/share-icon.js': '@empty',
             './icons/share-alt-icon.js': '@empty',
             './icons/share-alt-square-icon.js': '@empty',
             './icons/share-square-icon.js': '@empty',
             './icons/shekel-sign-icon.js': '@empty',
             './icons/shield-alt-icon.js': '@empty',
             './icons/ship-icon.js': '@empty',
             './icons/shipping-fast-icon.js': '@empty',
             './icons/shoe-prints-icon.js': '@empty',
             './icons/shopping-bag-icon.js': '@empty',
             './icons/shopping-basket-icon.js': '@empty',
             './icons/shopping-cart-icon.js': '@empty',
             './icons/shower-icon.js': '@empty',
             './icons/shuttle-van-icon.js': '@empty',
             './icons/sign-icon.js': '@empty',
             './icons/sign-in-alt-icon.js': '@empty',
             './icons/sign-language-icon.js': '@empty',
             './icons/sign-out-alt-icon.js': '@empty',
             './icons/signal-icon.js': '@empty',
             './icons/signature-icon.js': '@empty',
             './icons/sim-card-icon.js': '@empty',
             './icons/sitemap-icon.js': '@empty',
             './icons/skating-icon.js': '@empty',
             './icons/skiing-icon.js': '@empty',
             './icons/skiing-nordic-icon.js': '@empty',
             './icons/skull-icon.js': '@empty',
             './icons/skull-crossbones-icon.js': '@empty',
             './icons/slash-icon.js': '@empty',
             './icons/sleigh-icon.js': '@empty',
             './icons/sliders-h-icon.js': '@empty',
             './icons/smile-icon.js': '@empty',
             './icons/smile-beam-icon.js': '@empty',
             './icons/smile-wink-icon.js': '@empty',
             './icons/smog-icon.js': '@empty',
             './icons/smoking-icon.js': '@empty',
             './icons/smoking-ban-icon.js': '@empty',
             './icons/sms-icon.js': '@empty',
             './icons/snowboarding-icon.js': '@empty',
             './icons/snowflake-icon.js': '@empty',
             './icons/snowman-icon.js': '@empty',
             './icons/snowplow-icon.js': '@empty',
             './icons/socks-icon.js': '@empty',
             './icons/solar-panel-icon.js': '@empty',
             './icons/sort-icon.js': '@empty',
             './icons/sort-alpha-down-icon.js': '@empty',
             './icons/sort-alpha-up-icon.js': '@empty',
             './icons/sort-amount-down-icon.js': '@empty',
             './icons/sort-amount-up-icon.js': '@empty',
             './icons/sort-down-icon.js': '@empty',
             './icons/sort-numeric-down-icon.js': '@empty',
             './icons/sort-numeric-up-icon.js': '@empty',
             './icons/sort-up-icon.js': '@empty',
             './icons/spa-icon.js': '@empty',
             './icons/space-shuttle-icon.js': '@empty',
             './icons/spider-icon.js': '@empty',
             './icons/spinner-icon.js': '@empty',
             './icons/splotch-icon.js': '@empty',
             './icons/spray-can-icon.js': '@empty',
             './icons/square-icon.js': '@empty',
             './icons/square-full-icon.js': '@empty',
             './icons/square-root-alt-icon.js': '@empty',
             './icons/stamp-icon.js': '@empty',
             './icons/star-icon.js': '@empty',
             './icons/star-and-crescent-icon.js': '@empty',
             './icons/star-half-icon.js': '@empty',
             './icons/star-half-alt-icon.js': '@empty',
             './icons/star-of-david-icon.js': '@empty',
             './icons/star-of-life-icon.js': '@empty',
             './icons/step-backward-icon.js': '@empty',
             './icons/step-forward-icon.js': '@empty',
             './icons/stethoscope-icon.js': '@empty',
             './icons/sticky-note-icon.js': '@empty',
             './icons/stop-icon.js': '@empty',
             './icons/stop-circle-icon.js': '@empty',
             './icons/stopwatch-icon.js': '@empty',
             './icons/store-icon.js': '@empty',
             './icons/store-alt-icon.js': '@empty',
             './icons/stream-icon.js': '@empty',
             './icons/street-view-icon.js': '@empty',
             './icons/strikethrough-icon.js': '@empty',
             './icons/stroopwafel-icon.js': '@empty',
             './icons/subscript-icon.js': '@empty',
             './icons/subway-icon.js': '@empty',
             './icons/suitcase-icon.js': '@empty',
             './icons/suitcase-rolling-icon.js': '@empty',
             './icons/sun-icon.js': '@empty',
             './icons/superscript-icon.js': '@empty',
             './icons/surprise-icon.js': '@empty',
             './icons/swatchbook-icon.js': '@empty',
             './icons/swimmer-icon.js': '@empty',
             './icons/swimming-pool-icon.js': '@empty',
             './icons/synagogue-icon.js': '@empty',
             './icons/sync-icon.js': '@empty',
             './icons/sync-alt-icon.js': '@empty',
             './icons/syringe-icon.js': '@empty',
             './icons/table-icon.js': '@empty',
             './icons/table-tennis-icon.js': '@empty',
             './icons/tablet-icon.js': '@empty',
             './icons/tablet-alt-icon.js': '@empty',
             './icons/tablets-icon.js': '@empty',
             './icons/tachometer-alt-icon.js': '@empty',
             './icons/tag-icon.js': '@empty',
             './icons/tags-icon.js': '@empty',
             './icons/tape-icon.js': '@empty',
             './icons/tasks-icon.js': '@empty',
             './icons/taxi-icon.js': '@empty',
             './icons/teeth-icon.js': '@empty',
             './icons/teeth-open-icon.js': '@empty',
             './icons/temperature-high-icon.js': '@empty',
             './icons/temperature-low-icon.js': '@empty',
             './icons/tenge-icon.js': '@empty',
             './icons/terminal-icon.js': '@empty',
             './icons/text-height-icon.js': '@empty',
             './icons/text-width-icon.js': '@empty',
             './icons/th-icon.js': '@empty',
             './icons/th-large-icon.js': '@empty',
             './icons/th-list-icon.js': '@empty',
             './icons/theater-masks-icon.js': '@empty',
             './icons/thermometer-icon.js': '@empty',
             './icons/thermometer-empty-icon.js': '@empty',
             './icons/thermometer-full-icon.js': '@empty',
             './icons/thermometer-half-icon.js': '@empty',
             './icons/thermometer-quarter-icon.js': '@empty',
             './icons/thermometer-three-quarters-icon.js': '@empty',
             './icons/thumbs-down-icon.js': '@empty',
             './icons/thumbs-up-icon.js': '@empty',
             './icons/thumbtack-icon.js': '@empty',
             './icons/ticket-alt-icon.js': '@empty',
             './icons/times-icon.js': '@empty',
             './icons/times-circle-icon.js': '@empty',
             './icons/tint-icon.js': '@empty',
             './icons/tint-slash-icon.js': '@empty',
             './icons/tired-icon.js': '@empty',
             './icons/toggle-off-icon.js': '@empty',
             './icons/toggle-on-icon.js': '@empty',
             './icons/toilet-icon.js': '@empty',
             './icons/toilet-paper-icon.js': '@empty',
             './icons/toolbox-icon.js': '@empty',
             './icons/tools-icon.js': '@empty',
             './icons/tooth-icon.js': '@empty',
             './icons/torah-icon.js': '@empty',
             './icons/torii-gate-icon.js': '@empty',
             './icons/tractor-icon.js': '@empty',
             './icons/trademark-icon.js': '@empty',
             './icons/traffic-light-icon.js': '@empty',
             './icons/train-icon.js': '@empty',
             './icons/tram-icon.js': '@empty',
             './icons/transgender-icon.js': '@empty',
             './icons/transgender-alt-icon.js': '@empty',
             './icons/trash-icon.js': '@empty',
             './icons/trash-alt-icon.js': '@empty',
             './icons/trash-restore-icon.js': '@empty',
             './icons/trash-restore-alt-icon.js': '@empty',
             './icons/tree-icon.js': '@empty',
             './icons/trophy-icon.js': '@empty',
             './icons/truck-icon.js': '@empty',
             './icons/truck-loading-icon.js': '@empty',
             './icons/truck-monster-icon.js': '@empty',
             './icons/truck-moving-icon.js': '@empty',
             './icons/truck-pickup-icon.js': '@empty',
             './icons/tshirt-icon.js': '@empty',
             './icons/tty-icon.js': '@empty',
             './icons/tv-icon.js': '@empty',
             './icons/umbrella-icon.js': '@empty',
             './icons/umbrella-beach-icon.js': '@empty',
             './icons/underline-icon.js': '@empty',
             './icons/undo-icon.js': '@empty',
             './icons/undo-alt-icon.js': '@empty',
             './icons/universal-access-icon.js': '@empty',
             './icons/university-icon.js': '@empty',
             './icons/unlink-icon.js': '@empty',
             './icons/unlock-icon.js': '@empty',
             './icons/unlock-alt-icon.js': '@empty',
             './icons/upload-icon.js': '@empty',
             './icons/user-icon.js': '@empty',
             './icons/user-alt-icon.js': '@empty',
             './icons/user-alt-slash-icon.js': '@empty',
             './icons/user-astronaut-icon.js': '@empty',
             './icons/user-check-icon.js': '@empty',
             './icons/user-circle-icon.js': '@empty',
             './icons/user-clock-icon.js': '@empty',
             './icons/user-cog-icon.js': '@empty',
             './icons/user-edit-icon.js': '@empty',
             './icons/user-friends-icon.js': '@empty',
             './icons/user-graduate-icon.js': '@empty',
             './icons/user-injured-icon.js': '@empty',
             './icons/user-lock-icon.js': '@empty',
             './icons/user-md-icon.js': '@empty',
             './icons/user-minus-icon.js': '@empty',
             './icons/user-ninja-icon.js': '@empty',
             './icons/user-nurse-icon.js': '@empty',
             './icons/user-plus-icon.js': '@empty',
             './icons/user-secret-icon.js': '@empty',
             './icons/user-shield-icon.js': '@empty',
             './icons/user-slash-icon.js': '@empty',
             './icons/user-tag-icon.js': '@empty',
             './icons/user-tie-icon.js': '@empty',
             './icons/user-times-icon.js': '@empty',
             './icons/users-icon.js': '@empty',
             './icons/users-cog-icon.js': '@empty',
             './icons/utensil-spoon-icon.js': '@empty',
             './icons/utensils-icon.js': '@empty',
             './icons/vector-square-icon.js': '@empty',
             './icons/venus-icon.js': '@empty',
             './icons/venus-double-icon.js': '@empty',
             './icons/venus-mars-icon.js': '@empty',
             './icons/vial-icon.js': '@empty',
             './icons/vials-icon.js': '@empty',
             './icons/video-icon.js': '@empty',
             './icons/video-slash-icon.js': '@empty',
             './icons/vihara-icon.js': '@empty',
             './icons/volleyball-ball-icon.js': '@empty',
             './icons/volume-down-icon.js': '@empty',
             './icons/volume-mute-icon.js': '@empty',
             './icons/volume-off-icon.js': '@empty',
             './icons/volume-up-icon.js': '@empty',
             './icons/vote-yea-icon.js': '@empty',
             './icons/vr-cardboard-icon.js': '@empty',
             './icons/walking-icon.js': '@empty',
             './icons/wallet-icon.js': '@empty',
             './icons/warehouse-icon.js': '@empty',
             './icons/water-icon.js': '@empty',
             './icons/weight-icon.js': '@empty',
             './icons/weight-hanging-icon.js': '@empty',
             './icons/wheelchair-icon.js': '@empty',
             './icons/wifi-icon.js': '@empty',
             './icons/wind-icon.js': '@empty',
             './icons/window-close-icon.js': '@empty',
             './icons/window-maximize-icon.js': '@empty',
             './icons/window-minimize-icon.js': '@empty',
             './icons/window-restore-icon.js': '@empty',
             './icons/wine-bottle-icon.js': '@empty',
             './icons/wine-glass-icon.js': '@empty',
             './icons/wine-glass-alt-icon.js': '@empty',
             './icons/won-sign-icon.js': '@empty',
             './icons/wrench-icon.js': '@empty',
             './icons/x-ray-icon.js': '@empty',
             './icons/yen-sign-icon.js': '@empty',
             './icons/yin-yang-icon.js': '@empty',
             './icons/outlined-address-book-icon.js': '@empty',
             './icons/outlined-address-card-icon.js': '@empty',
             './icons/outlined-angry-icon.js': '@empty',
             './icons/outlined-arrow-alt-circle-down-icon.js': '@empty',
             './icons/outlined-arrow-alt-circle-left-icon.js': '@empty',
             './icons/outlined-arrow-alt-circle-right-icon.js': '@empty',
             './icons/outlined-arrow-alt-circle-up-icon.js': '@empty',
             './icons/outlined-bell-icon.js': '@empty',
             './icons/outlined-bell-slash-icon.js': '@empty',
             './icons/outlined-bookmark-icon.js': '@empty',
             './icons/outlined-building-icon.js': '@empty',
             './icons/outlined-calendar-icon.js': '@empty',
             './icons/outlined-calendar-alt-icon.js': '@empty',
             './icons/outlined-calendar-check-icon.js': '@empty',
             './icons/outlined-calendar-minus-icon.js': '@empty',
             './icons/outlined-calendar-plus-icon.js': '@empty',
             './icons/outlined-calendar-times-icon.js': '@empty',
             './icons/outlined-caret-square-down-icon.js': '@empty',
             './icons/outlined-caret-square-left-icon.js': '@empty',
             './icons/outlined-caret-square-right-icon.js': '@empty',
             './icons/outlined-caret-square-up-icon.js': '@empty',
             './icons/outlined-chart-bar-icon.js': '@empty',
             './icons/outlined-check-circle-icon.js': '@empty',
             './icons/outlined-check-square-icon.js': '@empty',
             './icons/outlined-circle-icon.js': '@empty',
             './icons/outlined-clipboard-icon.js': '@empty',
             './icons/outlined-clock-icon.js': '@empty',
             './icons/outlined-clone-icon.js': '@empty',
             './icons/outlined-closed-captioning-icon.js': '@empty',
             './icons/outlined-comment-icon.js': '@empty',
             './icons/outlined-comment-alt-icon.js': '@empty',
             './icons/outlined-comment-dots-icon.js': '@empty',
             './icons/outlined-comments-icon.js': '@empty',
             './icons/outlined-compass-icon.js': '@empty',
             './icons/outlined-copy-icon.js': '@empty',
             './icons/outlined-copyright-icon.js': '@empty',
             './icons/outlined-credit-card-icon.js': '@empty',
             './icons/outlined-dizzy-icon.js': '@empty',
             './icons/outlined-dot-circle-icon.js': '@empty',
             './icons/outlined-edit-icon.js': '@empty',
             './icons/outlined-envelope-icon.js': '@empty',
             './icons/outlined-envelope-open-icon.js': '@empty',
             './icons/outlined-eye-icon.js': '@empty',
             './icons/outlined-eye-slash-icon.js': '@empty',
             './icons/outlined-file-icon.js': '@empty',
             './icons/outlined-file-alt-icon.js': '@empty',
             './icons/outlined-file-archive-icon.js': '@empty',
             './icons/outlined-file-audio-icon.js': '@empty',
             './icons/outlined-file-code-icon.js': '@empty',
             './icons/outlined-file-excel-icon.js': '@empty',
             './icons/outlined-file-image-icon.js': '@empty',
             './icons/outlined-file-pdf-icon.js': '@empty',
             './icons/outlined-file-powerpoint-icon.js': '@empty',
             './icons/outlined-file-video-icon.js': '@empty',
             './icons/outlined-file-word-icon.js': '@empty',
             './icons/outlined-flag-icon.js': '@empty',
             './icons/outlined-flushed-icon.js': '@empty',
             './icons/outlined-folder-icon.js': '@empty',
             './icons/outlined-folder-open-icon.js': '@empty',
             './icons/outlined-font-awesome-logo-full-icon.js': '@empty',
             './icons/outlined-frown-icon.js': '@empty',
             './icons/outlined-frown-open-icon.js': '@empty',
             './icons/outlined-futbol-icon.js': '@empty',
             './icons/outlined-gem-icon.js': '@empty',
             './icons/outlined-grimace-icon.js': '@empty',
             './icons/outlined-grin-icon.js': '@empty',
             './icons/outlined-grin-alt-icon.js': '@empty',
             './icons/outlined-grin-beam-icon.js': '@empty',
             './icons/outlined-grin-beam-sweat-icon.js': '@empty',
             './icons/outlined-grin-hearts-icon.js': '@empty',
             './icons/outlined-grin-squint-icon.js': '@empty',
             './icons/outlined-grin-squint-tears-icon.js': '@empty',
             './icons/outlined-grin-stars-icon.js': '@empty',
             './icons/outlined-grin-tears-icon.js': '@empty',
             './icons/outlined-grin-tongue-icon.js': '@empty',
             './icons/outlined-grin-tongue-squint-icon.js': '@empty',
             './icons/outlined-grin-tongue-wink-icon.js': '@empty',
             './icons/outlined-grin-wink-icon.js': '@empty',
             './icons/outlined-hand-lizard-icon.js': '@empty',
             './icons/outlined-hand-paper-icon.js': '@empty',
             './icons/outlined-hand-peace-icon.js': '@empty',
             './icons/outlined-hand-point-down-icon.js': '@empty',
             './icons/outlined-hand-point-left-icon.js': '@empty',
             './icons/outlined-hand-point-right-icon.js': '@empty',
             './icons/outlined-hand-point-up-icon.js': '@empty',
             './icons/outlined-hand-pointer-icon.js': '@empty',
             './icons/outlined-hand-rock-icon.js': '@empty',
             './icons/outlined-hand-scissors-icon.js': '@empty',
             './icons/outlined-hand-spock-icon.js': '@empty',
             './icons/outlined-handshake-icon.js': '@empty',
             './icons/outlined-hdd-icon.js': '@empty',
             './icons/outlined-heart-icon.js': '@empty',
             './icons/outlined-hospital-icon.js': '@empty',
             './icons/outlined-hourglass-icon.js': '@empty',
             './icons/outlined-id-badge-icon.js': '@empty',
             './icons/outlined-id-card-icon.js': '@empty',
             './icons/outlined-image-icon.js': '@empty',
             './icons/outlined-images-icon.js': '@empty',
             './icons/outlined-keyboard-icon.js': '@empty',
             './icons/outlined-kiss-icon.js': '@empty',
             './icons/outlined-kiss-beam-icon.js': '@empty',
             './icons/outlined-kiss-wink-heart-icon.js': '@empty',
             './icons/outlined-laugh-icon.js': '@empty',
             './icons/outlined-laugh-beam-icon.js': '@empty',
             './icons/outlined-laugh-squint-icon.js': '@empty',
             './icons/outlined-laugh-wink-icon.js': '@empty',
             './icons/outlined-lemon-icon.js': '@empty',
             './icons/outlined-life-ring-icon.js': '@empty',
             './icons/outlined-lightbulb-icon.js': '@empty',
             './icons/outlined-list-alt-icon.js': '@empty',
             './icons/outlined-map-icon.js': '@empty',
             './icons/outlined-meh-icon.js': '@empty',
             './icons/outlined-meh-blank-icon.js': '@empty',
             './icons/outlined-meh-rolling-eyes-icon.js': '@empty',
             './icons/outlined-minus-square-icon.js': '@empty',
             './icons/outlined-money-bill-alt-icon.js': '@empty',
             './icons/outlined-moon-icon.js': '@empty',
             './icons/outlined-newspaper-icon.js': '@empty',
             './icons/outlined-object-group-icon.js': '@empty',
             './icons/outlined-object-ungroup-icon.js': '@empty',
             './icons/outlined-paper-plane-icon.js': '@empty',
             './icons/outlined-pause-circle-icon.js': '@empty',
             './icons/outlined-play-circle-icon.js': '@empty',
             './icons/outlined-plus-square-icon.js': '@empty',
             './icons/outlined-question-circle-icon.js': '@empty',
             './icons/outlined-registered-icon.js': '@empty',
             './icons/outlined-sad-cry-icon.js': '@empty',
             './icons/outlined-sad-tear-icon.js': '@empty',
             './icons/outlined-save-icon.js': '@empty',
             './icons/outlined-share-square-icon.js': '@empty',
             './icons/outlined-smile-icon.js': '@empty',
             './icons/outlined-smile-beam-icon.js': '@empty',
             './icons/outlined-smile-wink-icon.js': '@empty',
             './icons/outlined-snowflake-icon.js': '@empty',
             './icons/outlined-square-icon.js': '@empty',
             './icons/outlined-star-icon.js': '@empty',
             './icons/outlined-star-half-icon.js': '@empty',
             './icons/outlined-sticky-note-icon.js': '@empty',
             './icons/outlined-stop-circle-icon.js': '@empty',
             './icons/outlined-sun-icon.js': '@empty',
             './icons/outlined-surprise-icon.js': '@empty',
             './icons/outlined-thumbs-down-icon.js': '@empty',
             './icons/outlined-thumbs-up-icon.js': '@empty',
             './icons/outlined-times-circle-icon.js': '@empty',
             './icons/outlined-tired-icon.js': '@empty',
             './icons/outlined-trash-alt-icon.js': '@empty',
             './icons/outlined-user-icon.js': '@empty',
             './icons/outlined-user-circle-icon.js': '@empty',
             './icons/outlined-window-close-icon.js': '@empty',
             './icons/outlined-window-maximize-icon.js': '@empty',
             './icons/outlined-window-minimize-icon.js': '@empty',
             './icons/outlined-window-restore-icon.js': '@empty',
             './icons/openshift-icon.js': '@empty',
             './icons/cloudCircle-icon.js': '@empty',
             './icons/cloudServer-icon.js': '@empty',
             './icons/chartSpike-icon.js': '@empty',
             './icons/save-alt-icon.js': '@empty',
             './icons/folder-open-alt-icon.js': '@empty',
             './icons/edit-alt-icon.js': '@empty',
             './icons/print-alt-icon.js': '@empty',
             './icons/spinner-alt-icon.js': '@empty',
             './icons/home-alt-icon.js': '@empty',
             './icons/memory-alt-icon.js': '@empty',
             './icons/server-alt-icon.js': '@empty',
             './icons/user-sec-icon.js': '@empty',
             './icons/users-alt-icon.js': '@empty',
             './icons/info-alt-icon.js': '@empty',
             './icons/filter-alt-icon.js': '@empty',
             './icons/screen-icon.js': '@empty',
             './icons/ok-icon.js': '@empty',
             './icons/messages-icon.js': '@empty',
             './icons/help-icon.js': '@empty',
             './icons/folder-close-icon.js': '@empty',
             './icons/topology-icon.js': '@empty',
             './icons/close-icon.js': '@empty',
             './icons/equalizer-icon.js': '@empty',
             './icons/remove2-icon.js': '@empty',
             './icons/spinner2-icon.js': '@empty',
             './icons/import-icon.js': '@empty',
             './icons/export-icon.js': '@empty',
             './icons/add-circle-o-icon.js': '@empty',
             './icons/service-icon.js': '@empty',
             './icons/os-image-icon.js': '@empty',
             './icons/cluster-icon.js': '@empty',
             './icons/container-node-icon.js': '@empty',
             './icons/registry-icon.js': '@empty',
             './icons/replicator-icon.js': '@empty',
             './icons/globe-route-icon.js': '@empty',
             './icons/builder-image-icon.js': '@empty',
             './icons/trend-down-icon.js': '@empty',
             './icons/trend-up-icon.js': '@empty',
             './icons/build-icon.js': '@empty',
             './icons/cloud-security-icon.js': '@empty',
             './icons/cloud-tenant-icon.js': '@empty',
             './icons/project-icon.js': '@empty',
             './icons/enterprise-icon.js': '@empty',
             './icons/flavor-icon.js': '@empty',
             './icons/network-icon.js': '@empty',
             './icons/regions-icon.js': '@empty',
             './icons/repository-icon.js': '@empty',
             './icons/resource-pool-icon.js': '@empty',
             './icons/storage-domain-icon.js': '@empty',
             './icons/virtual-machine-icon.js': '@empty',
             './icons/volume-icon.js': '@empty',
             './icons/zone-icon.js': '@empty',
             './icons/resources-almost-full-icon.js': '@empty',
             './icons/warning-triangle-icon.js': '@empty',
             './icons/private-icon.js': '@empty',
             './icons/blueprint-icon.js': '@empty',
             './icons/tenant-icon.js': '@empty',
             './icons/middleware-icon.js': '@empty',
             './icons/bundle-icon.js': '@empty',
             './icons/domain-icon.js': '@empty',
             './icons/server-group-icon.js': '@empty',
             './icons/degraded-icon.js': '@empty',
             './icons/rebalance-icon.js': '@empty',
             './icons/resources-almost-empty-icon.js': '@empty',
             './icons/thumb-tack-icon.js': '@empty',
             './icons/unlocked-icon.js': '@empty',
             './icons/locked-icon.js': '@empty',
             './icons/asleep-icon.js': '@empty',
             './icons/error-circle-o-icon.js': '@empty',
             './icons/cpu-icon.js': '@empty',
             './icons/chat-icon.js': '@empty',
             //'./icons/arrow-icon.js': '@empty',
             './icons/resources-full-icon.js': '@empty',
             './icons/in-progress-icon.js': '@empty',
             './icons/maintenance-icon.js': '@empty',
             './icons/migration-icon.js': '@empty',
             './icons/off-icon.js': '@empty',
             './icons/on-running-icon.js': '@empty',
             './icons/on-icon.js': '@empty',
             './icons/paused-icon.js': '@empty',
             './icons/pending-icon.js': '@empty',
             './icons/rebooting-icon.js': '@empty',
             './icons/unknown-icon.js': '@empty',
             './icons/applications-icon.js': '@empty',
             './icons/automation-icon.js': '@empty',
             './icons/connected-icon.js': '@empty',
             './icons/catalog-icon.js': '@empty',
             './icons/enhancement-icon.js': '@empty',
             './icons/pficon-history-icon.js': '@empty',
             './icons/disconnected-icon.js': '@empty',
             './icons/infrastructure-icon.js': '@empty',
             './icons/optimize-icon.js': '@empty',
             './icons/orders-icon.js': '@empty',
             './icons/plugged-icon.js': '@empty',
             './icons/service-catalog-icon.js': '@empty',
             './icons/unplugged-icon.js': '@empty',
             './icons/monitoring-icon.js': '@empty',
             './icons/port-icon.js': '@empty',
             './icons/security-icon.js': '@empty',
             './icons/services-icon.js': '@empty',
             './icons/integration-icon.js': '@empty',
             './icons/process-automation-icon.js': '@empty',
             './icons/pficon-network-range-icon.js': '@empty',
             './icons/pficon-satellite-icon.js': '@empty',
             './icons/pficon-template-icon.js': '@empty',
             './icons/pficon-vcenter-icon.js': '@empty',
             './icons/pficon-sort-common-asc-icon.js': '@empty',
             './icons/pficon-sort-common-desc-icon.js': '@empty',
             './icons/pficon-dragdrop-icon.js': '@empty',
              
          }
      },
    }
  });
})(this);
