/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat7;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.adapters.UserSessionManagement;

public class CatalinaUserSessionManagement
implements SessionListener,
UserSessionManagement {
    private static final Logger log = Logger.getLogger("" + CatalinaUserSessionManagement.class);
    protected ConcurrentHashMap<String, UserSessions> userSessionMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, UserSessions> keycloakSessionMap = new ConcurrentHashMap();

    public synchronized int getActiveSessions() {
        return this.keycloakSessionMap.size();
    }

    public synchronized Long getUserLoginTime(String username) {
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            return null;
        }
        return sessions.getLoggedIn();
    }

    public synchronized Set<String> getActiveUsers() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.userSessionMap.keySet());
        return set;
    }

    public synchronized void login(Session session, String username, String keycloakSessionId) {
        String sessionId = session.getId();
        UserSessions sessions = this.userSessionMap.get(username);
        if (sessions == null) {
            sessions = new UserSessions();
            sessions.user = username;
            this.userSessionMap.put(username, sessions);
        }
        this.keycloakSessionMap.put(keycloakSessionId, sessions);
        sessions.httpSessionToKeycloakSession.put(sessionId, keycloakSessionId);
        sessions.keycloakSessionToHttpSession.put(keycloakSessionId, sessionId);
        sessions.sessions.put(sessionId, session);
        session.addSessionListener((SessionListener)this);
    }

    public void logoutAll() {
        for (String user : this.userSessionMap.keySet()) {
            this.logoutUser(user);
        }
    }

    public void logoutUser(String user) {
        UserSessions sessions = null;
        sessions = this.userSessionMap.remove(user);
        if (sessions == null) {
            return;
        }
        for (Map.Entry<String, String> entry : sessions.httpSessionToKeycloakSession.entrySet()) {
            String sessionId = entry.getKey();
            String keycloakSessionId = entry.getValue();
            Session session = sessions.sessions.get(sessionId);
            session.setPrincipal(null);
            session.setAuthType(null);
            session.getSession().invalidate();
            this.keycloakSessionMap.remove(keycloakSessionId);
        }
    }

    public synchronized void logoutKeycloakSession(String keycloakSessionId) {
        UserSessions sessions = this.keycloakSessionMap.remove(keycloakSessionId);
        if (sessions == null) {
            return;
        }
        String sessionId = sessions.keycloakSessionToHttpSession.remove(keycloakSessionId);
        if (sessionId == null) {
            // empty if block
        }
        sessions.httpSessionToKeycloakSession.remove(sessionId);
        Session session = sessions.sessions.remove(sessionId);
        session.setPrincipal(null);
        session.setAuthType(null);
        session.getSession().invalidate();
        if (sessions.keycloakSessionToHttpSession.size() == 0) {
            this.userSessionMap.remove(sessions.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType()) && !"passivateSession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            return;
        }
        session.setPrincipal(null);
        session.setAuthType(null);
        String username = principal.getUserPrincipal().getName();
        UserSessions userSessions = this.userSessionMap.get(username);
        if (userSessions == null) {
            return;
        }
        String sessionid = session.getId();
        CatalinaUserSessionManagement catalinaUserSessionManagement = this;
        synchronized (catalinaUserSessionManagement) {
            String keycloakSessionId = userSessions.httpSessionToKeycloakSession.remove(sessionid);
            if (keycloakSessionId != null) {
                userSessions.keycloakSessionToHttpSession.remove(keycloakSessionId);
                this.keycloakSessionMap.remove(keycloakSessionId);
            }
            userSessions.sessions.remove(sessionid);
            if (userSessions.httpSessionToKeycloakSession.size() == 0) {
                this.userSessionMap.remove(username);
            }
        }
    }

    public static class UserSessions {
        protected String user;
        protected long loggedIn = System.currentTimeMillis();
        protected Map<String, String> keycloakSessionToHttpSession = new HashMap<String, String>();
        protected Map<String, String> httpSessionToKeycloakSession = new HashMap<String, String>();
        protected Map<String, Session> sessions = new HashMap<String, Session>();

        public long getLoggedIn() {
            return this.loggedIn;
        }
    }
}

