/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat7;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.tomcat7.AuthenticatedActionsValve;
import org.keycloak.adapters.tomcat7.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat7.CatalinaRequestAuthenticator;
import org.keycloak.adapters.tomcat7.CatalinaUserSessionManagement;

public class KeycloakAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    private static final Logger log = Logger.getLogger("" + KeycloakAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected AdapterDeploymentContext deploymentContext;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            try {
                this.startDeployment();
            }
            catch (LifecycleException e) {
                log.severe("Error starting deployment. " + e.getMessage());
            }
        } else if ("after_start".equals(event.getType())) {
            this.initInternal();
        }
    }

    public void logout(Request request) throws ServletException {
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (ksc != null) {
            request.removeAttribute(KeycloakSecurityContext.class.getName());
            Session session = request.getSessionInternal(false);
            if (session != null) {
                session.removeNote(KeycloakSecurityContext.class.getName());
                try {
                    CatalinaHttpFacade facade = new CatalinaHttpFacade(request, null);
                    ServerRequest.invokeLogout((KeycloakDeployment)this.deploymentContext.resolveDeployment((HttpFacade)facade), (String)ksc.getToken().getSessionState());
                }
                catch (Exception e) {
                    log.severe("failed to invoke remote logout. " + e.getMessage());
                }
            }
        }
        super.logout(request);
    }

    public void startDeployment() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
        this.cache = false;
    }

    public void initInternal() {
        InputStream configInputStream = KeycloakAuthenticatorValve.getConfigInputStream(this.context);
        KeycloakDeployment kd = null;
        if (configInputStream == null) {
            log.warning("No adapter configuration.  Keycloak is unconfigured and will deny all requests.");
            kd = new KeycloakDeployment();
        } else {
            kd = KeycloakDeploymentBuilder.build((InputStream)configInputStream);
        }
        this.deploymentContext = new AdapterDeploymentContext(kd);
        this.context.getServletContext().setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.deploymentContext, this.getNext(), this.getContainer(), this.getObjectName());
        this.setNext((Valve)actions);
    }

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        log.info("**** using org.keycloak.json.adapterConfig");
        log.info(json);
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = KeycloakAuthenticatorValve.getJSONFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.info("**** using /WEB-INF/keycloak.json");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    log.severe("NOT FOUND /WEB-INF/keycloak.json");
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, (HttpServletResponse)response);
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)this.userSessionManagement, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.checkKeycloakSession(request, facade);
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            return false;
        }
        CatalinaRequestAuthenticator authenticator = new CatalinaRequestAuthenticator(deployment, this, this.userSessionManagement, facade, request);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            return !facade.isEnded();
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    protected void checkKeycloakSession(Request request, HttpFacade facade) {
        if (request.getSessionInternal(false) == null || request.getPrincipal() == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)request.getSessionInternal().getNote(KeycloakSecurityContext.class.getName());
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setDeployment(this.deploymentContext.resolveDeployment(facade));
        }
        if (session.isActive()) {
            return;
        }
        session.refreshExpiredToken();
        if (session.isActive()) {
            return;
        }
        request.getSessionInternal().removeNote(KeycloakSecurityContext.class.getName());
        request.setUserPrincipal(null);
        request.setAuthType(null);
        request.getSessionInternal().setPrincipal(null);
        request.getSessionInternal().setAuthType(null);
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

