/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.RealmConfiguration;
import org.keycloak.ResourceMetadata;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.config.ManagedResourceConfig;
import org.keycloak.adapters.undertow.BearerTokenAuthenticator;
import org.keycloak.adapters.undertow.KeycloakChallenge;
import org.keycloak.adapters.undertow.OAuthAuthenticator;
import org.keycloak.representations.SkeletonKeyToken;

public class KeycloakAuthenticationMechanism
implements AuthenticationMechanism {
    protected Logger log = Logger.getLogger(KeycloakAuthenticationMechanism.class);
    public static final AttachmentKey<KeycloakChallenge> KEYCLOAK_CHALLENGE_ATTACHMENT_KEY = AttachmentKey.create(KeycloakChallenge.class);
    public static final AttachmentKey<SkeletonKeySession> SKELETON_KEY_SESSION_ATTACHMENT_KEY = AttachmentKey.create(SkeletonKeySession.class);
    protected ResourceMetadata resourceMetadata;
    protected ManagedResourceConfig config;
    protected RealmConfiguration realmConfig;
    protected int sslRedirectPort;

    public KeycloakAuthenticationMechanism(ResourceMetadata resourceMetadata, ManagedResourceConfig config, RealmConfiguration realmConfig, int sslRedirectPort) {
        this.resourceMetadata = resourceMetadata;
        this.config = config;
        this.realmConfig = realmConfig;
        this.sslRedirectPort = sslRedirectPort;
    }

    public KeycloakAuthenticationMechanism(ResourceMetadata resourceMetadata, ManagedResourceConfig config, RealmConfiguration realmConfig) {
        this.resourceMetadata = resourceMetadata;
        this.config = config;
        this.realmConfig = realmConfig;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        BearerTokenAuthenticator bearer = this.createBearerTokenAuthenticator();
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = bearer.authenticate(exchange);
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)bearer.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
            SkeletonKeyToken token = bearer.getToken();
            String surrogate = bearer.getSurrogate();
            SkeletonKeySession session = new SkeletonKeySession(bearer.getTokenString(), token, this.resourceMetadata);
            this.propagateBearer(exchange, session);
            this.completeAuthentication(exchange, securityContext, token, surrogate);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        if (this.config.isBearerOnly()) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)bearer.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        OAuthAuthenticator oauth = this.createOAuthAuthenticator(exchange);
        outcome = oauth.authenticate();
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)oauth.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)oauth.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        SkeletonKeySession session = new SkeletonKeySession(oauth.getTokenString(), oauth.getToken(), this.resourceMetadata);
        this.propagateOauth(exchange, session);
        this.completeAuthentication(exchange, securityContext, oauth.getToken(), null);
        this.log.info((Object)"AUTHENTICATED");
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    protected OAuthAuthenticator createOAuthAuthenticator(HttpServerExchange exchange) {
        return new OAuthAuthenticator(exchange, this.realmConfig, this.sslRedirectPort);
    }

    protected BearerTokenAuthenticator createBearerTokenAuthenticator() {
        return new BearerTokenAuthenticator(this.resourceMetadata, this.config.isUseResourceRoleMappings());
    }

    protected void completeAuthentication(HttpServerExchange exchange, SecurityContext securityContext, SkeletonKeyToken token, String surrogate) {
        SkeletonKeyToken.Access access;
        final SkeletonKeyPrincipal skeletonKeyPrincipal = new SkeletonKeyPrincipal(token.getPrincipal(), surrogate);
        Set roles = null;
        if (this.config.isUseResourceRoleMappings()) {
            access = token.getResourceAccess(this.resourceMetadata.getResourceName());
            if (access != null) {
                roles = access.getRoles();
            }
        } else {
            access = token.getRealmAccess();
            if (access != null) {
                roles = access.getRoles();
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        final Set accountRoles = roles;
        Account account = new Account(){

            public Principal getPrincipal() {
                return skeletonKeyPrincipal;
            }

            public Set<String> getRoles() {
                return accountRoles;
            }
        };
        securityContext.authenticationComplete(account, "FORM");
    }

    protected void propagateBearer(HttpServerExchange exchange, SkeletonKeySession session) {
        exchange.putAttachment(SKELETON_KEY_SESSION_ATTACHMENT_KEY, (Object)session);
    }

    protected void propagateOauth(HttpServerExchange exchange, SkeletonKeySession session) {
        exchange.putAttachment(SKELETON_KEY_SESSION_ATTACHMENT_KEY, (Object)session);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        KeycloakChallenge challenge = (KeycloakChallenge)exchange.getAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY);
        if (challenge != null) {
            return challenge.sendChallenge(exchange, securityContext);
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }
}

