/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.config.ManagedResourceConfig;
import org.keycloak.adapters.undertow.AuthenticatedActionsHandler;

public class ServletAuthenticatedActionsHandler
extends AuthenticatedActionsHandler {
    protected ServletAuthenticatedActionsHandler(ManagedResourceConfig config, HttpHandler next) {
        super(config, next);
    }

    @Override
    public SkeletonKeySession getSkeletonKeySession(HttpServerExchange exchange) {
        SkeletonKeySession skSession = super.getSkeletonKeySession(exchange);
        if (skSession != null) {
            return skSession;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpSession session = req.getSession(false);
        if (session == null) {
            return null;
        }
        return (SkeletonKeySession)session.getAttribute(SkeletonKeySession.class.getName());
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected ManagedResourceConfig config;

        public Wrapper(ManagedResourceConfig config) {
            this.config = config;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new ServletAuthenticatedActionsHandler(this.config, handler);
        }
    }
}

