/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import org.jboss.logging.Logger;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.undertow.KeycloakAuthenticationMechanism;
import org.keycloak.adapters.undertow.PreflightCorsHandler;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class AuthenticatedActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(AuthenticatedActionsHandler.class);
    protected AdapterConfig adapterConfig;
    protected HttpHandler next;

    protected AuthenticatedActionsHandler(AdapterConfig config, HttpHandler next) {
        this.adapterConfig = config;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        log.debugv("AuthenticatedActionsValve.invoke {0}", (Object)exchange.getRequestURI());
        SkeletonKeySession session = this.getSkeletonKeySession(exchange);
        if (this.corsRequest(exchange, session)) {
            return;
        }
        String requestUri = exchange.getRequestURI();
        if (requestUri.endsWith("k_query_bearer_token")) {
            this.queryBearerToken(exchange, session);
            return;
        }
        this.next.handleRequest(exchange);
    }

    public SkeletonKeySession getSkeletonKeySession(HttpServerExchange exchange) {
        SkeletonKeySession skSession = (SkeletonKeySession)exchange.getAttachment(KeycloakAuthenticationMechanism.SKELETON_KEY_SESSION_ATTACHMENT_KEY);
        if (skSession != null) {
            return skSession;
        }
        return null;
    }

    protected void queryBearerToken(HttpServerExchange exchange, SkeletonKeySession session) throws IOException, ServletException {
        log.debugv("queryBearerToken {0}", (Object)exchange.getRequestURI());
        if (this.abortTokenResponse(exchange, session)) {
            return;
        }
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
        exchange.getResponseSender().send(session.getTokenString());
        exchange.endExchange();
    }

    protected boolean abortTokenResponse(HttpServerExchange exchange, SkeletonKeySession session) throws IOException {
        if (session == null) {
            log.debugv("session was null, sending back 401: {0}", (Object)exchange.getRequestURI());
            exchange.setResponseCode(200);
            exchange.endExchange();
            return true;
        }
        if (!this.adapterConfig.isExposeToken()) {
            exchange.setResponseCode(200);
            exchange.endExchange();
            return true;
        }
        if (!this.adapterConfig.isCors() && exchange.getRequestHeaders().getFirst(Headers.ORIGIN) != null) {
            exchange.setResponseCode(200);
            exchange.endExchange();
            return true;
        }
        return false;
    }

    protected boolean corsRequest(HttpServerExchange exchange, SkeletonKeySession session) throws IOException {
        if (!this.adapterConfig.isCors()) {
            return false;
        }
        log.debugv("CORS enabled + request.getRequestURI()", new Object[0]);
        String origin = exchange.getRequestHeaders().getFirst("Origin");
        log.debugv("Origin: {0} uri: {1}", (Object)origin, (Object)exchange.getRequestURI());
        if (session != null && origin != null) {
            SkeletonKeyToken token = session.getToken();
            Set allowedOrigins = token.getAllowedOrigins();
            if (log.isDebugEnabled()) {
                for (String a : allowedOrigins) {
                    log.debug((Object)("   " + a));
                }
            }
            if (allowedOrigins == null || !allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                if (allowedOrigins == null) {
                    log.debugv("allowedOrigins was null in token", new Object[0]);
                }
                if (!allowedOrigins.contains("*") && !allowedOrigins.contains(origin)) {
                    log.debugv("allowedOrigins did not contain origin", new Object[0]);
                }
                exchange.setResponseCode(403);
                exchange.endExchange();
                return true;
            }
            log.debugv("returning origin: {0}", (Object)origin);
            exchange.setResponseCode(200);
            exchange.getResponseHeaders().put(PreflightCorsHandler.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            exchange.getResponseHeaders().put(PreflightCorsHandler.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else {
            log.debugv("session or origin was null: {0}", (Object)exchange.getRequestURI());
        }
        return false;
    }
}

