/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.InputStream;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.adapters.undertow.UserSessionManagement;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.util.StreamUtil;

public class ServletAdminActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(ServletAdminActionsHandler.class);
    protected HttpHandler next;
    protected UserSessionManagement userSessionManagement;
    protected RealmConfiguration realmConfig;

    protected ServletAdminActionsHandler(RealmConfiguration realmConfig, UserSessionManagement userSessionManagement, HttpHandler next) {
        this.next = next;
        this.userSessionManagement = userSessionManagement;
        this.realmConfig = realmConfig;
    }

    protected JWSInput verifyAdminRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String token = StreamUtil.readString((InputStream)request.getInputStream());
        if (token == null) {
            log.warn((Object)"admin request failed, no token");
            response.sendError(403, "no token");
            return null;
        }
        JWSInput input = new JWSInput(token);
        boolean verified = false;
        try {
            verified = RSAProvider.verify((JWSInput)input, (PublicKey)this.realmConfig.getMetadata().getRealmKey());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (!verified) {
            log.warn((Object)"admin request failed, unable to verify token");
            response.sendError(403, "verification failed");
            return null;
        }
        return input;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        log.debugv("adminActions {0}", (Object)exchange.getRequestURI());
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        SessionManager manager = servletRequestContext.getDeployment().getSessionManager();
        String requestUri = exchange.getRequestURI();
        if (requestUri.endsWith("k_logout")) {
            JWSInput token = this.verifyAdminRequest(request, response);
            if (token == null) {
                return;
            }
            this.userSessionManagement.remoteLogout(token, manager, response);
            return;
        }
        this.next.handleRequest(exchange);
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected RealmConfiguration realmConfig;
        protected UserSessionManagement userSessionManagement;

        public Wrapper(RealmConfiguration realmConfig, UserSessionManagement userSessionManagement) {
            this.realmConfig = realmConfig;
            this.userSessionManagement = userSessionManagement;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new ServletAdminActionsHandler(this.realmConfig, this.userSessionManagement, handler);
        }
    }
}

