/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.adapters.undertow.KeycloakAuthenticationMechanism;
import org.keycloak.adapters.undertow.OAuthAuthenticator;
import org.keycloak.adapters.undertow.ServletOAuthAuthenticator;
import org.keycloak.adapters.undertow.UserSessionManagement;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class ServletKeycloakAuthenticationMechanism
extends KeycloakAuthenticationMechanism {
    protected ConfidentialPortManager portManager;
    protected UserSessionManagement userSessionManagement;

    public ServletKeycloakAuthenticationMechanism(UserSessionManagement userSessionManagement, AdapterConfig config, RealmConfiguration realmConfig, ConfidentialPortManager portManager) {
        super(config, realmConfig);
        this.portManager = portManager;
        this.userSessionManagement = userSessionManagement;
    }

    public ServletKeycloakAuthenticationMechanism(AdapterConfig config, ResourceMetadata metadata, ConfidentialPortManager portManager) {
        super(config, metadata);
        this.portManager = portManager;
        this.userSessionManagement = this.userSessionManagement;
    }

    @Override
    protected OAuthAuthenticator createOAuthAuthenticator(HttpServerExchange exchange) {
        return new ServletOAuthAuthenticator(exchange, this.realmConfig, this.portManager);
    }

    @Override
    protected void propagateBearer(HttpServerExchange exchange, SkeletonKeySession skSession, SkeletonKeyPrincipal principal) {
        super.propagateBearer(exchange, skSession, principal);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
    }

    @Override
    protected void propagateOauth(HttpServerExchange exchange, SkeletonKeySession skSession, SkeletonKeyPrincipal principal) {
        super.propagateBearer(exchange, skSession, principal);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        HttpSession session = req.getSession(true);
        session.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        this.userSessionManagement.login(servletRequestContext.getDeployment().getSessionManager(), session, principal.getName());
    }
}

