/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.adapters.undertow.BearerTokenAuthenticator;
import org.keycloak.adapters.undertow.KeycloakChallenge;
import org.keycloak.adapters.undertow.OAuthAuthenticator;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class KeycloakAuthenticationMechanism
implements AuthenticationMechanism {
    protected Logger log = Logger.getLogger(KeycloakAuthenticationMechanism.class);
    public static final AttachmentKey<KeycloakChallenge> KEYCLOAK_CHALLENGE_ATTACHMENT_KEY = AttachmentKey.create(KeycloakChallenge.class);
    public static final AttachmentKey<SkeletonKeySession> SKELETON_KEY_SESSION_ATTACHMENT_KEY = AttachmentKey.create(SkeletonKeySession.class);
    protected ResourceMetadata resourceMetadata;
    protected AdapterConfig adapterConfig;
    protected RealmConfiguration realmConfig;
    protected int sslRedirectPort;

    public KeycloakAuthenticationMechanism(AdapterConfig config, RealmConfiguration realmConfig, int sslRedirectPort) {
        this.resourceMetadata = realmConfig.getMetadata();
        this.adapterConfig = config;
        this.realmConfig = realmConfig;
        this.sslRedirectPort = sslRedirectPort;
    }

    public KeycloakAuthenticationMechanism(AdapterConfig adapterConfig, ResourceMetadata resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
        this.adapterConfig = adapterConfig;
    }

    public KeycloakAuthenticationMechanism(AdapterConfig adapterConfig, RealmConfiguration realmConfig) {
        this.resourceMetadata = realmConfig.getMetadata();
        this.adapterConfig = adapterConfig;
        this.realmConfig = realmConfig;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        BearerTokenAuthenticator bearer = this.createBearerTokenAuthenticator();
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = bearer.authenticate(exchange);
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)bearer.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED) {
            SkeletonKeyToken token = bearer.getToken();
            String surrogate = bearer.getSurrogate();
            SkeletonKeySession session = new SkeletonKeySession(bearer.getTokenString(), token, this.resourceMetadata);
            SkeletonKeyPrincipal principal = this.completeAuthentication(securityContext, token, surrogate);
            this.propagateBearer(exchange, session, principal);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        if (this.adapterConfig.isBearerOnly()) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)bearer.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        OAuthAuthenticator oauth = this.createOAuthAuthenticator(exchange);
        outcome = oauth.authenticate();
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)oauth.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (outcome == AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED) {
            exchange.putAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY, (Object)oauth.getChallenge());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        SkeletonKeySession session = new SkeletonKeySession(oauth.getTokenString(), oauth.getToken(), this.resourceMetadata);
        SkeletonKeyPrincipal principal = this.completeAuthentication(securityContext, oauth.getToken(), null);
        this.propagateOauth(exchange, session, principal);
        this.log.info((Object)"AUTHENTICATED");
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    protected OAuthAuthenticator createOAuthAuthenticator(HttpServerExchange exchange) {
        return new OAuthAuthenticator(exchange, this.realmConfig, this.sslRedirectPort);
    }

    protected BearerTokenAuthenticator createBearerTokenAuthenticator() {
        return new BearerTokenAuthenticator(this.resourceMetadata, this.adapterConfig.isUseResourceRoleMappings());
    }

    protected SkeletonKeyPrincipal completeAuthentication(SecurityContext securityContext, SkeletonKeyToken token, String surrogate) {
        SkeletonKeyToken.Access access;
        final SkeletonKeyPrincipal skeletonKeyPrincipal = new SkeletonKeyPrincipal(token.getSubject(), surrogate);
        Set roles = null;
        if (this.adapterConfig.isUseResourceRoleMappings()) {
            access = token.getResourceAccess(this.resourceMetadata.getResourceName());
            if (access != null) {
                roles = access.getRoles();
            }
        } else {
            access = token.getRealmAccess();
            if (access != null) {
                roles = access.getRoles();
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        final Set accountRoles = roles;
        Account account = new Account(){

            public Principal getPrincipal() {
                return skeletonKeyPrincipal;
            }

            public Set<String> getRoles() {
                return accountRoles;
            }
        };
        securityContext.authenticationComplete(account, "KEYCLOAK", true);
        return skeletonKeyPrincipal;
    }

    protected void propagateBearer(HttpServerExchange exchange, SkeletonKeySession session, SkeletonKeyPrincipal principal) {
        exchange.putAttachment(SKELETON_KEY_SESSION_ATTACHMENT_KEY, (Object)session);
    }

    protected void propagateOauth(HttpServerExchange exchange, SkeletonKeySession session, SkeletonKeyPrincipal principal) {
        exchange.putAttachment(SKELETON_KEY_SESSION_ATTACHMENT_KEY, (Object)session);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        KeycloakChallenge challenge = (KeycloakChallenge)exchange.getAttachment(KEYCLOAK_CHALLENGE_ATTACHMENT_KEY);
        if (challenge != null) {
            return challenge.sendChallenge(exchange, securityContext);
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }
}

