/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.Headers;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.adapters.TokenGrantRequest;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.adapters.undertow.KeycloakChallenge;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.util.KeycloakUriBuilder;

public class OAuthAuthenticator {
    private static final Logger log = Logger.getLogger(OAuthAuthenticator.class);
    protected RealmConfiguration realmInfo;
    protected int sslRedirectPort;
    protected String tokenString;
    protected SkeletonKeyToken token;
    protected HttpServerExchange exchange;
    protected KeycloakChallenge challenge;
    protected static final AtomicLong counter = new AtomicLong();

    public OAuthAuthenticator(HttpServerExchange exchange, RealmConfiguration realmInfo, int sslRedirectPort) {
        this.exchange = exchange;
        this.realmInfo = realmInfo;
        this.sslRedirectPort = sslRedirectPort;
    }

    public KeycloakChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public SkeletonKeyToken getToken() {
        return this.token;
    }

    protected String getRequestUrl() {
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)this.exchange.getRequestURI()).replaceQuery(this.exchange.getQueryString());
        if (!this.exchange.isHostIncludedInRequestURI()) {
            uriBuilder.scheme(this.exchange.getRequestScheme()).host(this.exchange.getHostAndPort());
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    protected boolean isRequestSecure() {
        return this.exchange.getProtocol().toString().equalsIgnoreCase("https");
    }

    protected Cookie getCookie(String cookieName) {
        Map requestCookies = this.exchange.getRequestCookies();
        if (requestCookies == null) {
            return null;
        }
        return (Cookie)requestCookies.get(cookieName);
    }

    protected String getCookieValue(String cookieName) {
        Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getQueryParamValue(String paramName) {
        Map queryParameters = this.exchange.getQueryParameters();
        if (queryParameters == null) {
            return null;
        }
        Deque strings = (Deque)queryParameters.get(paramName);
        if (strings == null) {
            return null;
        }
        return (String)strings.getFirst();
    }

    protected String getError() {
        return this.getQueryParamValue("error");
    }

    protected String getCode() {
        return this.getQueryParamValue("code");
    }

    protected String getRedirectUri(String state) {
        String url = this.getRequestUrl();
        log.infof("sending redirect uri: %s", (Object)url);
        if (!this.isRequestSecure() && this.realmInfo.isSslRequired()) {
            int port = this.sslRedirectPort();
            if (port < 0) {
                return null;
            }
            KeycloakUriBuilder secureUrl = KeycloakUriBuilder.fromUri((String)url).scheme("https").port(-1);
            if (port != 443) {
                secureUrl.port(port);
            }
            url = secureUrl.build(new Object[0]).toString();
        }
        return this.realmInfo.getAuthUrl().clone().queryParam("client_id", new Object[]{this.realmInfo.getMetadata().getResourceName()}).queryParam("redirect_uri", new Object[]{url}).queryParam("state", new Object[]{state}).queryParam("login", new Object[]{"true"}).build(new Object[0]).toString();
    }

    protected int sslRedirectPort() {
        return this.sslRedirectPort;
    }

    protected String getStateCode() {
        return counter.getAndIncrement() + "/" + UUID.randomUUID().toString();
    }

    protected KeycloakChallenge loginRedirect() {
        final String state = this.getStateCode();
        final String redirect = this.getRedirectUri(state);
        return new KeycloakChallenge(){

            @Override
            public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
                if (redirect == null) {
                    return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(403));
                }
                CookieImpl cookie = new CookieImpl(OAuthAuthenticator.this.realmInfo.getStateCookieName(), state);
                cookie.setSecure(OAuthAuthenticator.this.realmInfo.isSslRequired());
                exchange.setResponseCookie((Cookie)cookie);
                exchange.getResponseHeaders().put(Headers.LOCATION, redirect);
                return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(302));
            }
        };
    }

    protected KeycloakChallenge checkStateCookie() {
        Cookie stateCookie = this.getCookie(this.realmInfo.getStateCookieName());
        if (stateCookie == null) {
            log.warn((Object)"No state cookie");
            return this.challenge(400);
        }
        log.info((Object)"** reseting application state cookie");
        CookieImpl reset = new CookieImpl(this.realmInfo.getStateCookieName(), "");
        reset.setPath(stateCookie.getPath());
        reset.setMaxAge(Integer.valueOf(0));
        this.exchange.setResponseCookie((Cookie)reset);
        String stateCookieValue = this.getCookieValue(this.realmInfo.getStateCookieName());
        String state = this.getQueryParamValue("state");
        if (state == null) {
            log.warn((Object)"state parameter was null");
            return this.challenge(400);
        }
        if (!state.equals(stateCookieValue)) {
            log.warn((Object)"state parameter invalid");
            log.warn((Object)("cookie: " + stateCookieValue));
            log.warn((Object)("queryParam: " + state));
            return this.challenge(400);
        }
        return null;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate() {
        String code = this.getCode();
        if (code == null) {
            log.info((Object)"there was no code");
            String error = this.getError();
            if (error != null) {
                log.warn((Object)("There was an error: " + error));
                this.challenge = this.challenge(400);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            log.info((Object)"redirecting to auth server");
            this.challenge = this.loginRedirect();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        log.info((Object)"there was a code, resolving");
        this.challenge = this.resolveCode(code);
        if (this.challenge != null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    protected KeycloakChallenge challenge(final int code) {
        return new KeycloakChallenge(){

            @Override
            public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange httpServerExchange, SecurityContext securityContext) {
                return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(code));
            }
        };
    }

    protected KeycloakChallenge resolveCode(String code) {
        if (this.realmInfo.isSslRequired() && !this.isRequestSecure()) {
            log.error((Object)"SSL is required");
            return this.challenge(403);
        }
        log.info((Object)"checking state cookie for after code");
        KeycloakChallenge challenge = this.checkStateCookie();
        if (challenge != null) {
            return challenge;
        }
        AccessTokenResponse tokenResponse = null;
        String redirectUri = this.stripOauthParametersFromRedirect();
        try {
            tokenResponse = TokenGrantRequest.invoke((RealmConfiguration)this.realmInfo, (String)code, (String)redirectUri);
        }
        catch (TokenGrantRequest.HttpFailure failure) {
            log.error((Object)"failed to turn code into token");
            log.error((Object)("status from server: " + failure.getStatus()));
            if (failure.getStatus() == 400 && failure.getError() != null) {
                log.error((Object)("   " + failure.getError()));
            }
            return this.challenge(403);
        }
        catch (IOException e) {
            log.error((Object)"failed to turn code into token", (Throwable)e);
            return this.challenge(403);
        }
        this.tokenString = tokenResponse.getToken();
        try {
            this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (PublicKey)this.realmInfo.getMetadata().getRealmKey(), (String)this.realmInfo.getMetadata().getRealm());
            log.debug((Object)"Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)"failed verification of token");
            return this.challenge(403);
        }
        log.info((Object)"successful authenticated");
        return null;
    }

    protected String stripOauthParametersFromRedirect() {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)this.exchange.getRequestURI()).replaceQuery(this.exchange.getQueryString()).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }
}

