/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.util.JsonSerialization;

public class UserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(UserSessionManagement.class);
    private static final String AUTH_SESSION_NAME = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
    protected ConcurrentHashMap<String, Set<String>> userSessionMap = new ConcurrentHashMap();
    protected RealmConfiguration realmInfo;

    public UserSessionManagement(RealmConfiguration realmInfo) {
        this.realmInfo = realmInfo;
    }

    public void remoteLogout(JWSInput token, SessionManager manager, HttpServletResponse response) throws IOException {
        try {
            log.debug((Object)"->> remoteLogout: ");
            LogoutAction action = (LogoutAction)JsonSerialization.readValue((byte[])token.getContent(), LogoutAction.class);
            if (action.isExpired()) {
                log.warn((Object)"admin request failed, expired token");
                response.sendError(400, "Expired token");
                return;
            }
            if (!this.realmInfo.getMetadata().getResourceName().equals(action.getResource())) {
                log.warn((Object)"Resource name does not match");
                response.sendError(400, "Resource name does not match");
                return;
            }
            String user = action.getUser();
            if (user != null) {
                log.debug((Object)("logout of session for: " + user));
                this.logout(manager, user);
            } else {
                log.debug((Object)"logout of all sessions");
                this.logoutAll(manager);
            }
        }
        catch (Exception e) {
            log.warn((Object)"failed to logout", (Throwable)e);
            response.sendError(500, "Failed to logout");
        }
        response.setStatus(204);
    }

    public void login(SessionManager manager, HttpSession session, String username) {
        String sessionId = session.getId();
        this.addAuthenticatedSession(username, sessionId);
        manager.registerSessionListener((SessionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthenticatedSession(String username, String sessionId) {
        ConcurrentHashMap<String, Set<String>> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            HashSet<String> value;
            HashSet<String> map = this.userSessionMap.get(username);
            if (map == null && (map = (HashSet<String>)this.userSessionMap.putIfAbsent(username, value = new HashSet<String>())) == null) {
                map = value;
            }
            HashSet<String> hashSet = map;
            synchronized (hashSet) {
                map.add(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthenticatedSession(String sessionId, String username) {
        ConcurrentHashMap<String, Set<String>> concurrentHashMap = this.userSessionMap;
        synchronized (concurrentHashMap) {
            Set<String> map = this.userSessionMap.get(username);
            if (map == null) {
                return;
            }
            Set<String> set = map;
            synchronized (set) {
                map.remove(sessionId);
                if (map.isEmpty()) {
                    this.userSessionMap.remove(username);
                }
            }
        }
    }

    public void logoutAll(SessionManager manager) {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            this.logout(manager, user);
        }
    }

    public void logoutAllBut(SessionManager manager, String but) {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            if (but.equals(user)) continue;
            this.logout(manager, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(SessionManager manager, String user) {
        log.debug((Object)("logoutUser: " + user));
        Set<String> map = this.userSessionMap.remove(user);
        if (map == null) {
            log.debug((Object)("no session for user: " + user));
            return;
        }
        log.debug((Object)"found session for user");
        Set<String> set = map;
        synchronized (set) {
            for (String id : map) {
                log.debug((Object)("invalidating session for user: " + user));
                Session session = manager.getSession(id);
                try {
                    session.invalidate(null);
                }
                catch (Exception e) {
                    log.warn((Object)"Session already invalidated.");
                }
            }
        }
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        String sessionId = session.getId();
        this.removeAuthenticatedSession(sessionId, username);
    }

    protected String getUsernameFromSession(Session session) {
        AuthenticatedSessionManager.AuthenticatedSession authSession = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(AUTH_SESSION_NAME);
        if (authSession == null) {
            return null;
        }
        return authSession.getAccount().getPrincipal().getName();
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        String username = this.getUsernameFromSession(session);
        if (username == null) {
            return;
        }
        this.removeAuthenticatedSession(oldSessionId, username);
        this.addAuthenticatedSession(session.getId(), username);
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }
}

