/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public class UndertowAuthenticatedActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(UndertowAuthenticatedActionsHandler.class);
    protected KeycloakDeployment deployment;
    protected HttpHandler next;

    protected UndertowAuthenticatedActionsHandler(KeycloakDeployment deployment, HttpHandler next) {
        this.deployment = deployment;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AuthenticatedActionsHandler handler = new AuthenticatedActionsHandler(this.deployment, (HttpFacade)new UndertowHttpFacade(exchange));
        if (handler.handledRequest()) {
            return;
        }
        this.next.handleRequest(exchange);
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected KeycloakDeployment deployment;

        public Wrapper(KeycloakDeployment deployment) {
            this.deployment = deployment;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new UndertowAuthenticatedActionsHandler(this.deployment, handler);
        }
    }
}

