/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.undertow.SessionManagementBridge;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class ServletPreAuthActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(ServletPreAuthActionsHandler.class);
    protected HttpHandler next;
    protected UndertowUserSessionManagement userSessionManagement;
    protected KeycloakDeployment deployment;

    protected ServletPreAuthActionsHandler(KeycloakDeployment deployment, UndertowUserSessionManagement userSessionManagement, HttpHandler next) {
        this.next = next;
        this.deployment = deployment;
        this.userSessionManagement = userSessionManagement;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        SessionManagementBridge bridge = new SessionManagementBridge(this.userSessionManagement, servletRequestContext.getDeployment().getSessionManager());
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)bridge, this.deployment, (HttpFacade)new UndertowHttpFacade(exchange));
        if (handler.handleRequest()) {
            return;
        }
        this.next.handleRequest(exchange);
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected KeycloakDeployment deployment;
        protected UndertowUserSessionManagement userSessionManagement;

        public Wrapper(KeycloakDeployment deployment, UndertowUserSessionManagement userSessionManagement) {
            this.deployment = deployment;
            this.userSessionManagement = userSessionManagement;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new ServletPreAuthActionsHandler(this.deployment, this.userSessionManagement, handler);
        }
    }
}

