/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public class UndertowRequestAuthenticator
extends RequestAuthenticator {
    protected SecurityContext securityContext;
    protected HttpServerExchange exchange;

    public UndertowRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, SecurityContext securityContext, HttpServerExchange exchange) {
        super(facade, deployment, sslRedirectPort);
        this.securityContext = securityContext;
        this.exchange = exchange;
    }

    protected void propagateKeycloakContext(KeycloakUndertowAccount account) {
        this.exchange.putAttachment(UndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY, (Object)account.getKeycloakSecurityContext());
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this.facade, this.deployment, this.sslRedirectPort){

            protected void saveRequest() {
            }
        };
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext session) {
        KeycloakUndertowAccount account = new KeycloakUndertowAccount(principal, session, this.deployment);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
        this.login(account);
    }

    protected void login(KeycloakAccount account) {
    }

    protected void completeBearerAuthentication(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext session) {
        KeycloakUndertowAccount account = new KeycloakUndertowAccount(principal, session, this.deployment);
        this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
        this.propagateKeycloakContext(account);
    }

    protected boolean isCached() {
        return false;
    }
}

