/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public class UndertowAuthenticatedActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(UndertowAuthenticatedActionsHandler.class);
    protected AdapterDeploymentContext deploymentContext;
    protected HttpHandler next;

    protected UndertowAuthenticatedActionsHandler(AdapterDeploymentContext deploymentContext, HttpHandler next) {
        this.deploymentContext = deploymentContext;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AuthenticatedActionsHandler handler;
        UndertowHttpFacade facade = new UndertowHttpFacade(exchange);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment != null && deployment.isConfigured() && (handler = new AuthenticatedActionsHandler(deployment, (HttpFacade)facade)).handledRequest()) {
            return;
        }
        this.next.handleRequest(exchange);
    }

    public static class Wrapper
    implements HandlerWrapper {
        protected AdapterDeploymentContext deploymentContext;

        public Wrapper(AdapterDeploymentContext deploymentContext) {
            this.deploymentContext = deploymentContext;
        }

        public HttpHandler wrap(HttpHandler handler) {
            return new UndertowAuthenticatedActionsHandler(this.deploymentContext, handler);
        }
    }
}

