/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.ServletRequestAuthenticator;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowKeycloakAuthMech;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class ServletKeycloakAuthMech
extends UndertowKeycloakAuthMech {
    private static final Logger log = Logger.getLogger(ServletKeycloakAuthMech.class);
    protected UndertowUserSessionManagement userSessionManagement;
    protected ConfidentialPortManager portManager;

    public ServletKeycloakAuthMech(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, ConfidentialPortManager portManager) {
        super(deploymentContext);
        this.userSessionManagement = userSessionManagement;
        this.portManager = portManager;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade = new UndertowHttpFacade(exchange);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (!deployment.isConfigured()) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        RequestAuthenticator authenticator = this.createRequestAuthenticator(deployment, exchange, securityContext, facade);
        return this.keycloakAuthenticate(exchange, securityContext, authenticator);
    }

    @Override
    protected void registerNotifications(SecurityContext securityContext) {
        NotificationReceiver logoutReceiver = new NotificationReceiver(){

            public void handleNotification(SecurityNotification notification) {
                if (notification.getEventType() != SecurityNotification.EventType.LOGGED_OUT) {
                    return;
                }
                ServletRequestContext servletRequestContext = (ServletRequestContext)notification.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
                req.removeAttribute(KeycloakUndertowAccount.class.getName());
                req.removeAttribute(KeycloakSecurityContext.class.getName());
                HttpSession session = req.getSession(false);
                if (session == null) {
                    return;
                }
                KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
                if (account == null) {
                    return;
                }
                session.removeAttribute(KeycloakSecurityContext.class.getName());
                session.removeAttribute(KeycloakUndertowAccount.class.getName());
                String sessionId = account.getKeycloakSecurityContext().getToken().getSessionState();
                try {
                    ServerRequest.invokeLogout((KeycloakDeployment)ServletKeycloakAuthMech.this.deploymentContext.getDeployment(), (String)sessionId);
                }
                catch (Exception e) {
                    log.error((Object)"failed to invoke remote logout", (Throwable)e);
                }
            }
        };
        securityContext.registerNotificationReceiver(logoutReceiver);
    }

    protected RequestAuthenticator createRequestAuthenticator(KeycloakDeployment deployment, HttpServerExchange exchange, SecurityContext securityContext, UndertowHttpFacade facade) {
        int confidentialPort = this.getConfidentilPort(exchange);
        return new ServletRequestAuthenticator(facade, deployment, confidentialPort, securityContext, exchange, this.userSessionManagement);
    }

    protected int getConfidentilPort(HttpServerExchange exchange) {
        int confidentialPort = 8443;
        if (exchange.getRequestScheme().equalsIgnoreCase("HTTPS")) {
            confidentialPort = exchange.getHostPort();
        } else if (this.portManager != null) {
            confidentialPort = this.portManager.getConfidentialPort(exchange);
        }
        return confidentialPort;
    }
}

