/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.idm.Account;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.representations.AccessToken;

public class KeycloakUndertowAccount
implements Account,
Serializable,
KeycloakAccount {
    protected static Logger log = Logger.getLogger(KeycloakUndertowAccount.class);
    protected RefreshableKeycloakSecurityContext session;
    protected KeycloakPrincipal principal;
    protected Set<String> accountRoles;

    public KeycloakUndertowAccount(KeycloakPrincipal principal, RefreshableKeycloakSecurityContext session, KeycloakDeployment deployment) {
        this.principal = principal;
        this.session = session;
        this.setRoles(session.getToken());
    }

    protected void setRoles(AccessToken accessToken) {
        Set roles = null;
        if (this.session.getDeployment().isUseResourceRoleMappings()) {
            AccessToken.Access access;
            if (log.isTraceEnabled()) {
                log.trace((Object)"useResourceRoleMappings");
            }
            if ((access = accessToken.getResourceAccess(this.session.getDeployment().getResourceName())) != null) {
                roles = access.getRoles();
            }
        } else {
            AccessToken.Access access;
            if (log.isTraceEnabled()) {
                log.trace((Object)"use realm role mappings");
            }
            if ((access = accessToken.getRealmAccess()) != null) {
                roles = access.getRoles();
            }
        }
        if (roles == null) {
            roles = Collections.emptySet();
        }
        this.accountRoles = roles;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return this.accountRoles;
    }

    public RefreshableKeycloakSecurityContext getKeycloakSecurityContext() {
        return this.session;
    }

    public void setDeployment(KeycloakDeployment deployment) {
        this.session.setDeployment(deployment);
    }

    public boolean isActive() {
        if (this.session.isActive()) {
            log.debug((Object)"session is active");
            return true;
        }
        log.debug((Object)"session is not active try refresh");
        this.session.refreshExpiredToken();
        if (!this.session.isActive()) {
            log.debug((Object)"session is not active return with failure");
            return false;
        }
        log.debug((Object)"refresh succeeded");
        this.setRoles(this.session.getToken());
        return true;
    }
}

