/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ConfidentialPortManager;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.AbstractUndertowKeycloakAuthMech;
import org.keycloak.adapters.undertow.ServletRequestAuthenticator;
import org.keycloak.adapters.undertow.ServletSessionTokenStore;
import org.keycloak.adapters.undertow.UndertowCookieTokenStore;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;
import org.keycloak.enums.TokenStore;

public class ServletKeycloakAuthMech
extends AbstractUndertowKeycloakAuthMech {
    private static final Logger log = Logger.getLogger(ServletKeycloakAuthMech.class);
    protected NodesRegistrationManagement nodesRegistrationManagement;
    protected ConfidentialPortManager portManager;

    public ServletKeycloakAuthMech(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, NodesRegistrationManagement nodesRegistrationManagement, ConfidentialPortManager portManager) {
        super(deploymentContext, userSessionManagement);
        this.nodesRegistrationManagement = nodesRegistrationManagement;
        this.portManager = portManager;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowHttpFacade facade = new UndertowHttpFacade(exchange);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (!deployment.isConfigured()) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        this.nodesRegistrationManagement.tryRegister(deployment);
        RequestAuthenticator authenticator = this.createRequestAuthenticator(deployment, exchange, securityContext, facade);
        return this.keycloakAuthenticate(exchange, securityContext, authenticator);
    }

    protected RequestAuthenticator createRequestAuthenticator(KeycloakDeployment deployment, HttpServerExchange exchange, SecurityContext securityContext, UndertowHttpFacade facade) {
        int confidentialPort = this.getConfidentilPort(exchange);
        AdapterTokenStore tokenStore = this.getTokenStore(exchange, facade, deployment, securityContext);
        return new ServletRequestAuthenticator(facade, deployment, confidentialPort, securityContext, exchange, tokenStore);
    }

    protected int getConfidentilPort(HttpServerExchange exchange) {
        int confidentialPort = 8443;
        if (exchange.getRequestScheme().equalsIgnoreCase("HTTPS")) {
            confidentialPort = exchange.getHostPort();
        } else if (this.portManager != null) {
            confidentialPort = this.portManager.getConfidentialPort(exchange);
        }
        return confidentialPort;
    }

    @Override
    protected AdapterTokenStore getTokenStore(HttpServerExchange exchange, HttpFacade facade, KeycloakDeployment deployment, SecurityContext securityContext) {
        if (deployment.getTokenStore() == TokenStore.SESSION) {
            return new ServletSessionTokenStore(exchange, deployment, this.sessionManagement, securityContext);
        }
        return new UndertowCookieTokenStore(facade, deployment, securityContext);
    }
}

