/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.Theme;

public class FreeMarkerUtil {
    public static String processTemplate(Object data, String templateName, Theme theme) throws FreeMarkerException {
        StringWriter out = new StringWriter();
        Configuration cfg = new Configuration();
        try {
            cfg.setTemplateLoader((TemplateLoader)new ThemeTemplateLoader(theme));
            Template template = cfg.getTemplate(templateName);
            template.process(data, (Writer)out);
        }
        catch (Exception e) {
            throw new FreeMarkerException("Failed to process template " + templateName, e);
        }
        return ((Object)out).toString();
    }

    public static class ThemeTemplateLoader
    extends URLTemplateLoader {
        private Theme theme;

        public ThemeTemplateLoader(Theme theme) {
            this.theme = theme;
        }

        protected URL getURL(String name) {
            try {
                return this.theme.getTemplate(name);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

