/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.util.HashMap;
import java.util.Map;

public class RequestDetails {
    private String providerId;
    private Map<String, String> clientAttributes;
    private Map<String, String> socialAttributes;

    public static RequestDetailsBuilder create(String providerId) {
        RequestDetailsBuilder req = new RequestDetailsBuilder();
        req.providerId = providerId;
        req.clientAttributes = new HashMap();
        req.socialAttributes = new HashMap();
        return req;
    }

    public static RequestDetailsBuilder create(RequestDetails from) {
        RequestDetailsBuilder req = new RequestDetailsBuilder();
        req.providerId = from.getProviderId();
        req.clientAttributes = new HashMap();
        req.clientAttributes.putAll(from.getClientAttributes());
        req.socialAttributes = new HashMap();
        req.socialAttributes.putAll(from.getSocialAttributes());
        return req;
    }

    private RequestDetails(String providerId, Map<String, String> clientAttributes, Map<String, String> socialAttributes) {
        this.providerId = providerId;
        this.clientAttributes = clientAttributes;
        this.socialAttributes = socialAttributes;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getClientAttribute(String name) {
        return this.clientAttributes.get(name);
    }

    public Map<String, String> getClientAttributes() {
        return this.clientAttributes;
    }

    public String getSocialAttribute(String name) {
        return this.socialAttributes.get(name);
    }

    public Map<String, String> getSocialAttributes() {
        return this.socialAttributes;
    }

    public static class RequestDetailsBuilder {
        private String providerId;
        private Map<String, String> clientAttributes;
        private Map<String, String> socialAttributes;

        private RequestDetailsBuilder() {
        }

        public RequestDetailsBuilder putClientAttribute(String name, String value) {
            this.clientAttributes.put(name, value);
            return this;
        }

        public RequestDetailsBuilder putClientAttributes(Map<String, String> attributes) {
            this.clientAttributes.putAll(attributes);
            return this;
        }

        public RequestDetailsBuilder putSocialAttribute(String name, String value) {
            this.socialAttributes.put(name, value);
            return this;
        }

        public RequestDetailsBuilder putSocialAttributes(Map<String, String> attributes) {
            this.socialAttributes.putAll(attributes);
            return this;
        }

        public RequestDetails build() {
            return new RequestDetails(this.providerId, this.clientAttributes, this.socialAttributes);
        }
    }
}

