/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.provider.ProviderSession;

public class ExtendingThemeManager
implements ThemeProvider {
    private List<ThemeProvider> providers = new LinkedList<ThemeProvider>();
    private String defaultTheme;
    private int staticMaxAge;

    public ExtendingThemeManager(ProviderSession providerSession) {
        for (ThemeProvider p : providerSession.getAllProviders(ThemeProvider.class)) {
            if (p.getClass().equals(ExtendingThemeManager.class)) continue;
            this.providers.add(p);
        }
        Collections.sort(this.providers, new Comparator<ThemeProvider>(){

            @Override
            public int compare(ThemeProvider o1, ThemeProvider o2) {
                return o2.getProviderPriority() - o1.getProviderPriority();
            }
        });
        this.defaultTheme = Config.scope((String[])new String[]{"theme"}).get("default");
        this.staticMaxAge = Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge");
    }

    public int getStaticMaxAge() {
        return this.staticMaxAge;
    }

    @Override
    public int getProviderPriority() {
        return 0;
    }

    @Override
    public Theme createTheme(String name, Theme.Type type) throws IOException {
        Theme theme;
        if (name == null) {
            name = this.defaultTheme;
        }
        if ((theme = this.findTheme(name, type)).getParentName() != null) {
            LinkedList<Theme> themes = new LinkedList<Theme>();
            themes.add(theme);
            if (theme.getImportName() != null) {
                String[] s = theme.getImportName().split("/");
                themes.add(this.findTheme(s[1], Theme.Type.valueOf(s[0].toUpperCase())));
            }
            String parentName = theme.getParentName();
            while (parentName != null) {
                theme = this.findTheme(parentName, type);
                themes.add(theme);
                if (theme.getImportName() != null) {
                    String[] s = theme.getImportName().split("/");
                    themes.add(this.findTheme(s[1], Theme.Type.valueOf(s[0].toUpperCase())));
                }
                parentName = theme.getParentName();
            }
            return new ExtendingTheme(themes);
        }
        return theme;
    }

    @Override
    public Set<String> nameSet(Theme.Type type) {
        HashSet<String> themes = new HashSet<String>();
        for (ThemeProvider p : this.providers) {
            themes.addAll(p.nameSet(type));
        }
        return themes;
    }

    @Override
    public boolean hasTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.providers) {
            if (!p.hasTheme(name, type)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        this.providers = null;
    }

    private Theme findTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.providers) {
            if (!p.hasTheme(name, type)) continue;
            try {
                return p.createTheme(name, type);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + type.toString().toLowerCase() + " theme", e);
            }
        }
        throw new RuntimeException(type.toString().toLowerCase() + " theme '" + name + "' not found");
    }

    public static class ExtendingTheme
    implements Theme {
        private List<Theme> themes;

        public ExtendingTheme(List<Theme> themes) {
            this.themes = themes;
        }

        @Override
        public String getName() {
            return this.themes.get(0).getName();
        }

        @Override
        public String getParentName() {
            return this.themes.get(0).getParentName();
        }

        @Override
        public String getImportName() {
            return this.themes.get(0).getImportName();
        }

        @Override
        public Theme.Type getType() {
            return this.themes.get(0).getType();
        }

        @Override
        public URL getTemplate(String name) throws IOException {
            for (Theme t : this.themes) {
                URL template = t.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        @Override
        public InputStream getTemplateAsStream(String name) throws IOException {
            for (Theme t : this.themes) {
                InputStream template = t.getTemplateAsStream(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        @Override
        public URL getResource(String path) throws IOException {
            for (Theme t : this.themes) {
                URL resource = t.getResource(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String path) throws IOException {
            for (Theme t : this.themes) {
                InputStream resource = t.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        public Properties getMessages() throws IOException {
            Properties messages = new Properties();
            ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
            while (itr.hasPrevious()) {
                Properties m = itr.previous().getMessages();
                if (m == null) continue;
                messages.putAll((Map<?, ?>)m);
            }
            return messages;
        }

        @Override
        public Properties getProperties() throws IOException {
            Properties properties = new Properties();
            ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
            while (itr.hasPrevious()) {
                Properties p = itr.previous().getProperties();
                if (p == null) continue;
                properties.putAll((Map<?, ?>)p);
            }
            return properties;
        }
    }
}

