/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.api.types;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;

public class MapperRegistry {
    private Map<Class<?>, Mapper<?, ?>> appObjectMappers = new HashMap();
    private Map<Class<?>, Map<Class<?>, Mapper<?, ?>>> dbObjectMappers = new HashMap();

    public void addAppObjectMapper(Mapper<?, ?> mapper) {
        this.appObjectMappers.put(mapper.getTypeOfObjectToConvert(), mapper);
    }

    public void addDBObjectMapper(Mapper<?, ?> mapper) {
        Class<?> dbObjectType = mapper.getTypeOfObjectToConvert();
        Class<?> appObjectType = mapper.getExpectedReturnType();
        Map<Class<?>, Mapper<?, ?>> appObjects = this.dbObjectMappers.get(dbObjectType);
        if (appObjects == null) {
            appObjects = new HashMap();
            this.dbObjectMappers.put(dbObjectType, appObjects);
        }
        appObjects.put(appObjectType, mapper);
    }

    public <S> S convertDBObjectToApplicationObject(MapperContext<Object, S> context) {
        Object dbObject = context.getObjectToConvert();
        Class<S> expectedApplicationObjectType = context.getExpectedReturnType();
        Class<?> dbObjectType = dbObject.getClass();
        Map<Class<?>, Mapper<?, ?>> appObjects = this.dbObjectMappers.get(dbObjectType);
        if (appObjects == null) {
            throw new IllegalArgumentException("Not found any mappers for type " + dbObjectType);
        }
        Mapper<Object, ?> mapper = appObjects.size() == 1 ? appObjects.values().iterator().next() : MapperRegistry.getAppConverterForType(context.getExpectedReturnType(), appObjects);
        if (mapper == null) {
            throw new IllegalArgumentException("Can't found mapper for type " + dbObjectType + " and expectedApplicationType " + expectedApplicationObjectType);
        }
        return (S)mapper.convertObject(context);
    }

    public <S> S convertApplicationObjectToDBObject(Object applicationObject, Class<S> expectedDBObjectType) {
        Class<?> appObjectType = applicationObject.getClass();
        Mapper<Object, ?> mapper = MapperRegistry.getAppConverterForType(appObjectType, this.appObjectMappers);
        if (mapper == null) {
            throw new IllegalArgumentException("Can't found converter for type " + appObjectType + " in registered appObjectMappers");
        }
        if (!expectedDBObjectType.isAssignableFrom(mapper.getExpectedReturnType())) {
            throw new IllegalArgumentException("Converter " + mapper + " has return type " + mapper.getExpectedReturnType() + " but we need type " + expectedDBObjectType);
        }
        return (S)mapper.convertObject(new MapperContext<Object, S>(applicationObject, expectedDBObjectType, null));
    }

    private static Mapper<Object, ?> getAppConverterForType(Class<?> appObjectType, Map<Class<?>, Mapper<?, ?>> appObjectConverters) {
        Class<?>[] interfaces;
        Mapper<Object, ?> mapper = appObjectConverters.get(appObjectType);
        if (mapper != null) {
            return mapper;
        }
        for (Class<?> interface1 : interfaces = appObjectType.getInterfaces()) {
            mapper = MapperRegistry.getAppConverterForType(interface1, appObjectConverters);
            if (mapper == null) continue;
            return mapper;
        }
        Class<?> superType = appObjectType.getSuperclass();
        if (superType != null) {
            return MapperRegistry.getAppConverterForType(superType, appObjectConverters);
        }
        return null;
    }
}

