/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.net.URI;
import org.keycloak.freemarker.Theme;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.flows.Urls;

public class UrlBean {
    private String realm;
    private Theme theme;
    private URI baseURI;
    private URI baseQueryURI;
    private URI currentURI;
    private String stateChecker;

    public UrlBean(RealmModel realm, Theme theme, URI baseURI, URI baseQueryURI, URI currentURI, String stateChecker) {
        this.realm = realm.getName();
        this.theme = theme;
        this.baseURI = baseURI;
        this.baseQueryURI = baseQueryURI;
        this.currentURI = currentURI;
        this.stateChecker = stateChecker;
    }

    public String getAccessUrl() {
        return Urls.accountAccessPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getAccountUrl() {
        return Urls.accountPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getPasswordUrl() {
        return Urls.accountPasswordPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getSocialUrl() {
        return Urls.accountSocialPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getTotpUrl() {
        return Urls.accountTotpPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getLogUrl() {
        return Urls.accountLogPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getSessionsUrl() {
        return Urls.accountSessionsPage((URI)this.baseQueryURI, (String)this.realm).toString();
    }

    public String getSessionsLogoutUrl() {
        return Urls.accountSessionsLogoutPage((URI)this.baseQueryURI, (String)this.realm, (String)this.stateChecker).toString();
    }

    public String getTotpRemoveUrl() {
        return Urls.accountTotpRemove((URI)this.baseQueryURI, (String)this.realm, (String)this.stateChecker).toString();
    }

    public String getLogoutUrl() {
        return Urls.accountLogout((URI)this.baseQueryURI, (URI)this.currentURI, (String)this.realm).toString();
    }

    public String getResourcesPath() {
        URI uri = Urls.themeRoot((URI)this.baseURI);
        return uri.getPath() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }
}

