/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;

public class UserAdapter
implements UserModel {
    protected UserEntity user;
    protected EntityManager em;
    protected RealmModel realm;

    public UserAdapter(RealmModel realm, EntityManager em, UserEntity user) {
        this.em = em;
        this.user = user;
        this.realm = realm;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        this.user.setUsername(username);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setAttribute(String name, String value) {
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        UserAttributeEntity attr = new UserAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<UserAttributeEntity> it = this.user.getAttributes().iterator();
        while (it.hasNext()) {
            UserAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            result.add(attr.getAction());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            if (!attr.getAction().equals((Object)action)) continue;
            return;
        }
        UserRequiredActionEntity attr = new UserRequiredActionEntity();
        attr.setAction(action);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getRequiredActions().add(attr);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        Iterator<UserRequiredActionEntity> it = this.user.getRequiredActions().iterator();
        while (it.hasNext()) {
            UserRequiredActionEntity attr = it.next();
            if (!attr.getAction().equals((Object)action)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
    }

    public void updateCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setId(KeycloakModelUtils.generateId());
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            credentialEntity.setUser(this.user);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            int hashIterations = 1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null && (hashIterations = policy.getHashIterations()) == -1) {
                hashIterations = 1;
            }
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue(), hashIterations));
            credentialEntity.setSalt(salt);
            credentialEntity.setHashIterations(hashIterations);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.em.flush();
    }

    private CredentialEntity getCredentialEntity(UserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        ArrayList<CredentialEntity> credentials = new ArrayList<CredentialEntity>(this.user.getCredentials());
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        if (credentials != null) {
            for (CredentialEntity credEntity : credentials) {
                UserCredentialValueModel credModel = new UserCredentialValueModel();
                credModel.setType(credEntity.getType());
                credModel.setDevice(credEntity.getDevice());
                credModel.setValue(credEntity.getValue());
                credModel.setSalt(credEntity.getSalt());
                credModel.setHashIterations(credEntity.getHashIterations());
                result.add(credModel);
            }
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setId(KeycloakModelUtils.generateId());
            credentialEntity.setType(credModel.getType());
            credentialEntity.setUser(this.user);
            this.em.persist((Object)credentialEntity);
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
        this.em.flush();
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)this.getUser());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasRole(role)) {
            return;
        }
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(this.getUser());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings() {
        TypedQuery query = this.em.createNamedQuery("userRoleMappingIds", String.class);
        query.setParameter("user", (Object)this.getUser());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel roleById = this.realm.getRoleById(roleId);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getApplicationRoleMappings(ApplicationModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ApplicationModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ApplicationModel) || !(appModel = (ApplicationModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

