/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.BitArray;

public final class BitMatrix {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int dimension) {
        this(dimension, dimension);
    }

    public BitMatrix(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        this.rowSize = width + 31 >> 5;
        this.bits = new int[this.rowSize * height];
    }

    public boolean get(int x, int y) {
        int offset = y * this.rowSize + (x >> 5);
        return (this.bits[offset] >>> (x & 0x1F) & 1) != 0;
    }

    public void set(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + (x >> 5);
        this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
    }

    public void flip(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + (x >> 5);
        this.bits[n] = this.bits[n] ^ 1 << (x & 0x1F);
    }

    public void clear() {
        int max = this.bits.length;
        for (int i = 0; i < max; ++i) {
            this.bits[i] = 0;
        }
    }

    public void setRegion(int left, int top, int width, int height) {
        if (top < 0 || left < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int right = left + width;
        int bottom = top + height;
        if (bottom > this.height || right > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int y = top; y < bottom; ++y) {
            int offset = y * this.rowSize;
            for (int x = left; x < right; ++x) {
                int n = offset + (x >> 5);
                this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
            }
        }
    }

    public BitArray getRow(int y, BitArray row) {
        if (row == null || row.getSize() < this.width) {
            row = new BitArray(this.width);
        }
        int offset = y * this.rowSize;
        for (int x = 0; x < this.rowSize; ++x) {
            row.setBulk(x << 5, this.bits[offset + x]);
        }
        return row;
    }

    public void setRow(int y, BitArray row) {
        System.arraycopy(row.getBitArray(), 0, this.bits, y * this.rowSize, this.rowSize);
    }

    public int[] getEnclosingRectangle() {
        int left = this.width;
        int top = this.height;
        int right = -1;
        int bottom = -1;
        for (int y = 0; y < this.height; ++y) {
            for (int x32 = 0; x32 < this.rowSize; ++x32) {
                int bit;
                int theBits = this.bits[y * this.rowSize + x32];
                if (theBits == 0) continue;
                if (y < top) {
                    top = y;
                }
                if (y > bottom) {
                    bottom = y;
                }
                if (x32 * 32 < left) {
                    bit = 0;
                    while (theBits << 31 - bit == 0) {
                        ++bit;
                    }
                    if (x32 * 32 + bit < left) {
                        left = x32 * 32 + bit;
                    }
                }
                if (x32 * 32 + 31 <= right) continue;
                bit = 31;
                while (theBits >>> bit == 0) {
                    --bit;
                }
                if (x32 * 32 + bit <= right) continue;
                right = x32 * 32 + bit;
            }
        }
        int width = right - left;
        int height = bottom - top;
        if (width < 0 || height < 0) {
            return null;
        }
        return new int[]{left, top, width, height};
    }

    public int[] getTopLeftOnBit() {
        int bitsOffset;
        for (bitsOffset = 0; bitsOffset < this.bits.length && this.bits[bitsOffset] == 0; ++bitsOffset) {
        }
        if (bitsOffset == this.bits.length) {
            return null;
        }
        int y = bitsOffset / this.rowSize;
        int x = bitsOffset % this.rowSize << 5;
        int theBits = this.bits[bitsOffset];
        int bit = 0;
        while (theBits << 31 - bit == 0) {
            ++bit;
        }
        return new int[]{x += bit, y};
    }

    public int[] getBottomRightOnBit() {
        int bitsOffset;
        for (bitsOffset = this.bits.length - 1; bitsOffset >= 0 && this.bits[bitsOffset] == 0; --bitsOffset) {
        }
        if (bitsOffset < 0) {
            return null;
        }
        int y = bitsOffset / this.rowSize;
        int x = bitsOffset % this.rowSize << 5;
        int theBits = this.bits[bitsOffset];
        int bit = 31;
        while (theBits >>> bit == 0) {
            --bit;
        }
        return new int[]{x += bit, y};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitMatrix)) {
            return false;
        }
        BitMatrix other = (BitMatrix)o;
        if (this.width != other.width || this.height != other.height || this.rowSize != other.rowSize || this.bits.length != other.bits.length) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.width;
        hash = 31 * hash + this.width;
        hash = 31 * hash + this.height;
        hash = 31 * hash + this.rowSize;
        for (int bit : this.bits) {
            hash = 31 * hash + bit;
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.height * (this.width + 1));
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                result.append(this.get(x, y) ? "X " : "  ");
            }
            result.append('\n');
        }
        return result.toString();
    }
}

