/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.sessions.mongo.ClientSessionAdapter;
import org.keycloak.models.sessions.mongo.UserSessionAdapter;
import org.keycloak.models.sessions.mongo.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.mongo.entities.MongoClientSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUserSessionEntity;
import org.keycloak.models.sessions.mongo.entities.MongoUsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.util.Time;

public class MongoUserSessionProvider
implements UserSessionProvider {
    private final KeycloakSession session;
    private final MongoStore mongoStore;
    private final MongoStoreInvocationContext invocationContext;

    public MongoUserSessionProvider(KeycloakSession session, MongoStore mongoStore, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.mongoStore = mongoStore;
        this.invocationContext = invocationContext;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession, String redirectUri, String state, Set<String> roles) {
        MongoUserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession.getId());
        MongoClientSessionEntity entity = new MongoClientSessionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientId(client.getId());
        entity.setRedirectUri(redirectUri);
        entity.setState(state);
        if (roles != null) {
            entity.setRoles(new LinkedList<String>(roles));
        }
        this.mongoStore.pushItemToList((MongoIdentifiableEntity)userSessionEntity, "clientSessions", (Object)entity, false, this.invocationContext);
        return new ClientSessionAdapter(this.session, this, realm, entity, userSessionEntity, this.invocationContext);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("clientSessions.id").is((Object)id).get();
        List entities = this.mongoStore.loadEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        if (entities.isEmpty()) {
            return null;
        }
        MongoUserSessionEntity userSessionEntity = (MongoUserSessionEntity)((Object)entities.get(0));
        List<MongoClientSessionEntity> sessions = userSessionEntity.getClientSessions();
        if (sessions == null) {
            return null;
        }
        for (MongoClientSessionEntity s : sessions) {
            if (!s.getId().equals(id)) continue;
            return new ClientSessionAdapter(this.session, this, realm, s, userSessionEntity, this.invocationContext);
        }
        return null;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe) {
        MongoUserSessionEntity entity = new MongoUserSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.mongoStore.insertEntity((MongoIdentifiableEntity)entity, this.invocationContext);
        return new UserSessionAdapter(this.session, this, entity, realm, this.invocationContext);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        MongoUserSessionEntity entity = this.getUserSessionEntity(realm, id);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter(this.session, this, entity, realm, this.invocationContext);
    }

    MongoUserSessionEntity getUserSessionEntity(RealmModel realm, String id) {
        return (MongoUserSessionEntity)this.mongoStore.loadEntity(MongoUserSessionEntity.class, id, this.invocationContext);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.mongoStore.loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(this.session, this, e, realm, this.invocationContext));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        DBObject query = new QueryBuilder().and("clientSessions.clientId").is((Object)client.getId()).get();
        BasicDBObject sort = new BasicDBObject("started", (Object)1).append("id", (Object)1);
        List sessions = this.mongoStore.loadEntities(MongoUserSessionEntity.class, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        LinkedList<UserSessionModel> result = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity session : sessions) {
            result.add(new UserSessionAdapter(this.session, this, session, realm, this.invocationContext));
        }
        return result;
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientSessions.clientId").is((Object)client.getId()).get();
        return this.mongoStore.countEntities(MongoUserSessionEntity.class, query, this.invocationContext);
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        this.mongoStore.removeEntity((MongoIdentifiableEntity)((UserSessionAdapter)session).getMongoEntity(), this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeUserSessions(RealmModel realm) {
        BasicDBObject query = new BasicDBObject("realmId", (Object)realm.getId());
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        int currentTime = Time.currentTime();
        DBObject query = new QueryBuilder().and("started").lessThan((Object)(currentTime - realm.getSsoSessionMaxLifespan())).get();
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        query = new QueryBuilder().and("lastSessionRefresh").lessThan((Object)(currentTime - realm.getSsoSessionIdleTimeout())).get();
        this.mongoStore.removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        DBObject query = new QueryBuilder().and("username").is((Object)username).and("realmId").is((Object)realm.getId()).get();
        MongoUsernameLoginFailureEntity user = (MongoUsernameLoginFailureEntity)this.mongoStore.loadSingleEntity(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(this.invocationContext, user);
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        UsernameLoginFailureModel userLoginFailure = this.getUserLoginFailure(realm, username);
        if (userLoginFailure != null) {
            return userLoginFailure;
        }
        MongoUsernameLoginFailureEntity userEntity = new MongoUsernameLoginFailureEntity();
        userEntity.setUsername(username);
        userEntity.setRealmId(realm.getId());
        this.mongoStore.insertEntity((MongoIdentifiableEntity)userEntity, this.invocationContext);
        return new UsernameLoginFailureAdapter(this.invocationContext, userEntity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        List failures = this.mongoStore.loadEntities(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        LinkedList<UsernameLoginFailureModel> result = new LinkedList<UsernameLoginFailureModel>();
        if (failures == null) {
            return result;
        }
        for (MongoUsernameLoginFailureEntity failure : failures) {
            result.add(new UsernameLoginFailureAdapter(this.invocationContext, failure));
        }
        return result;
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientSessions.clientId").is((Object)client.getId()).get();
        List userSessionEntities = this.mongoStore.loadEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        for (MongoUserSessionEntity e : userSessionEntities) {
            if (e.getClientSessions() == null) continue;
            LinkedList<MongoClientSessionEntity> remove = new LinkedList<MongoClientSessionEntity>();
            for (MongoClientSessionEntity c : e.getClientSessions()) {
                if (!c.getClientId().equals(client.getId())) continue;
                remove.add(c);
            }
            for (MongoClientSessionEntity c : remove) {
                this.mongoStore.pullItemFromList((MongoIdentifiableEntity)e, "clientSessions", (Object)c, this.invocationContext);
            }
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user);
        DBObject query = new QueryBuilder().or(new DBObject[]{new BasicDBObject("username", (Object)user.getUsername()), new BasicDBObject("username", (Object)user.getEmail())}).and("realmId").is((Object)realm.getId()).get();
        this.mongoStore.removeEntities(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
    }

    public void close() {
    }
}

