/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.picketlink.PartitionManagerProvider;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;

public class LDAPFederationProviderFactory
implements UserFederationProviderFactory {
    private static final Logger logger = Logger.getLogger(LDAPFederationProviderFactory.class);
    public static final String PROVIDER_NAME = "ldap";

    public UserFederationProvider create(KeycloakSession session) {
        throw new IllegalAccessError("Illegal to call this method");
    }

    public LDAPFederationProvider getInstance(KeycloakSession session, UserFederationProviderModel model) {
        PartitionManagerProvider idmProvider = (PartitionManagerProvider)session.getProvider(PartitionManagerProvider.class);
        PartitionManager partition = idmProvider.getPartitionManager(model);
        return new LDAPFederationProvider(session, model, partition);
    }

    public void init(Config.Scope config) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    public Set<String> getConfigurationOptions() {
        return Collections.emptySet();
    }

    public void syncAllUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model) {
        logger.infof("Sync all users from LDAP to local store: realm: %s, federation provider: %s, current time: " + new Date(), (Object)realmId, (Object)model.getDisplayName());
        PartitionManagerProvider idmProvider = (PartitionManagerProvider)sessionFactory.create().getProvider(PartitionManagerProvider.class);
        PartitionManager partitionMgr = idmProvider.getPartitionManager(model);
        IdentityQuery userQuery = partitionMgr.createIdentityManager().createIdentityQuery(User.class);
        this.syncImpl(sessionFactory, (IdentityQuery<User>)userQuery, realmId, model);
    }

    public void syncChangedUsers(KeycloakSessionFactory sessionFactory, String realmId, UserFederationProviderModel model, Date lastSync) {
        logger.infof("Sync changed users from LDAP to local store: realm: %s, federation provider: %s, current time: " + new Date() + ", last sync time: " + lastSync, (Object)realmId, (Object)model.getDisplayName());
        PartitionManagerProvider idmProvider = (PartitionManagerProvider)sessionFactory.create().getProvider(PartitionManagerProvider.class);
        PartitionManager partitionMgr = idmProvider.getPartitionManager(model);
        IdentityManager identityManager = partitionMgr.createIdentityManager();
        IdentityQuery userQuery = identityManager.createIdentityQuery(User.class).setParameter(IdentityType.CREATED_AFTER, new Object[]{lastSync});
        this.syncImpl(sessionFactory, (IdentityQuery<User>)userQuery, realmId, model);
        userQuery = identityManager.createIdentityQuery(User.class).setParameter(IdentityType.MODIFIED_AFTER, new Object[]{lastSync});
        this.syncImpl(sessionFactory, (IdentityQuery<User>)userQuery, realmId, model);
    }

    protected void syncImpl(KeycloakSessionFactory sessionFactory, IdentityQuery<User> userQuery, final String realmId, final UserFederationProviderModel fedModel) {
        boolean pagination = Boolean.parseBoolean((String)fedModel.getConfig().get("pagination"));
        if (pagination) {
            String pageSizeConfig = (String)fedModel.getConfig().get("batchSizeForSync");
            int pageSize = pageSizeConfig != null ? Integer.parseInt(pageSizeConfig) : 1000;
            boolean nextPage = true;
            while (nextPage) {
                userQuery.setLimit(pageSize);
                final List users = userQuery.getResultList();
                nextPage = userQuery.getPaginationContext() != null;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                    public void run(KeycloakSession session) {
                        LDAPFederationProviderFactory.this.importPicketlinkUsers(session, realmId, fedModel, users);
                    }
                });
            }
        } else {
            final List users = userQuery.getResultList();
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    LDAPFederationProviderFactory.this.importPicketlinkUsers(session, realmId, fedModel, users);
                }
            });
        }
    }

    protected void importPicketlinkUsers(KeycloakSession session, String realmId, UserFederationProviderModel fedModel, List<User> users) {
        RealmModel realm = session.realms().getRealm(realmId);
        LDAPFederationProvider ldapFedProvider = this.getInstance(session, fedModel);
        ldapFedProvider.importPicketlinkUsers(realm, users, fedModel);
    }
}

