/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.FileUtil;
import liquibase.util.StringUtils;

public class ExecuteSqlCommand
extends AbstractCommand {
    private Database database;
    private String sql;
    private String sqlFile;

    @Override
    public String getName() {
        return "execute";
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSqlFile() {
        return this.sqlFile;
    }

    public void setSqlFile(String sqlFile) {
        this.sqlFile = sqlFile;
    }

    @Override
    public CommandValidationErrors validate() {
        CommandValidationErrors commandValidationErrors = new CommandValidationErrors(this);
        return commandValidationErrors;
    }

    @Override
    protected Object run() throws Exception {
        String[] sqlStrings;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        String sqlText = this.sqlFile == null ? this.sql : FileUtil.getContents(new File(this.sqlFile));
        String out = "";
        for (String sql : sqlStrings = StringUtils.processMutliLineSQL(sqlText, true, true, ";")) {
            if (sql.toLowerCase().matches("\\s*select .*")) {
                List<Map<String, ?>> rows = executor.queryForList(new RawSqlStatement(sql));
                out = out + "Output of " + sql + ":\n";
                if (rows.size() == 0) {
                    out = out + "-- Empty Resultset --\n";
                } else {
                    TreeSet<String> keys = new TreeSet<String>();
                    for (Map<String, ?> row : rows) {
                        keys.addAll(row.keySet());
                    }
                    out = out + StringUtils.join(keys, " | ") + " |\n";
                    for (Map<String, ?> row : rows) {
                        for (String key : keys) {
                            out = out + row.get(key) + " | ";
                        }
                        out = out + "\n";
                    }
                }
            } else {
                executor.execute(new RawSqlStatement(sql));
                out = out + "Successfully Executed: " + sql + "\n";
            }
            out = out + "\n";
        }
        return out.trim();
    }
}

