/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.CharType;

@DataTypeInfo(name="varchar", aliases={"java.sql.Types.VARCHAR", "java.lang.String", "varchar2", "character varying"}, minParameters=0, maxParameters=1, priority=1)
public class VarcharType
extends CharType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof OracleDatabase || database instanceof HsqlDatabase && ((HsqlDatabase)database).isUsingOracleSyntax()) {
            return new DatabaseDataType("VARCHAR2", this.getParameters());
        }
        if (database instanceof InformixDatabase && this.getSize() > 255) {
            return new DatabaseDataType("LVARCHAR", this.getParameters());
        }
        if (database instanceof MSSQLDatabase) {
            Object param1;
            if (this.getParameters() != null && this.getParameters().length > 0 && (param1 = this.getParameters()[0]).toString().matches("\\d+") && Long.valueOf(param1.toString()) > 8000L) {
                return new DatabaseDataType("VARCHAR", "MAX");
            }
            return new DatabaseDataType("VARCHAR", this.getParameters());
        }
        return super.toDatabaseDataType(database);
    }
}

