/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import liquibase.logging.Logger;
import liquibase.logging.core.DefaultLogger;
import liquibase.servicelocator.AssignableToPackageScanFilter;
import liquibase.servicelocator.CompositePackageScanFilter;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;
import liquibase.util.StringUtils;

public class DefaultPackageScanClassResolver
implements PackageScanClassResolver {
    protected final transient Logger log = new DefaultLogger();
    private Set<ClassLoader> classLoaders;
    private Set<PackageScanFilter> scanFilters;
    private Map<String, Set<Class>> allClassesByPackage = new HashMap<String, Set<Class>>();
    private Set<String> loadedPackages = new HashSet<String>();

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        try {
            this.getClassLoaders().add(classLoader);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    @Override
    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.log.debug("The thread context class loader: " + ccl + "  is used to load the class");
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(DefaultPackageScanClassResolver.class.getClassLoader());
        }
        return this.classLoaders;
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        this.log.debug("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames));
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    @Override
    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        if (!this.loadedPackages.contains(packageName)) {
            for (ClassLoader classLoader : set) {
                this.findAllClasses(packageName, classLoader);
            }
            this.loadedPackages.add(packageName);
        }
        this.findInAllClasses(test, packageName, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findAllClasses(String packageName, ClassLoader loader) {
        Enumeration<URL> urls;
        this.log.debug("Searching for all classes in package: " + packageName + " using classloader: " + loader.getClass().getName());
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.debug("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warning("Cannot read package: " + packageName, ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                File file;
                url = urls.nextElement();
                this.log.debug("URL from classloader: " + url);
                url = this.customResourceLocator(url);
                String urlPath = url.getFile();
                String host = null;
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (url.getProtocol().equals("vfs") && !urlPath.startsWith("vfs")) {
                    urlPath = "vfs:" + urlPath;
                }
                if (url.getProtocol().equals("vfszip") && !urlPath.startsWith("vfszip")) {
                    urlPath = "vfszip:" + urlPath;
                }
                this.log.debug("Decoded urlPath: " + urlPath + " with protocol: " + url.getProtocol());
                if (urlPath.startsWith("file:")) {
                    try {
                        URI uri = new URI(url.getFile());
                        host = uri.getHost();
                        urlPath = uri.getPath();
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.debug("It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.contains(".jar/") && !urlPath.contains(".jar!/")) {
                    urlPath = urlPath.replace(".jar/", ".jar!/");
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (host != null) {
                    urlPath = urlPath.startsWith("/") ? "//" + host + urlPath : "//" + host + "/" + urlPath;
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    this.log.debug("Loading from directory using file: " + file);
                    this.loadImplementationsInDirectory(packageName, file, loader);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || urlPath.startsWith("vfs:") || urlPath.startsWith("vfszip:")) {
                    URL urlStream = new URL(urlPath);
                    this.log.debug("Loading from jar using " + urlStream.getProtocol() + ": " + urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    this.log.debug("Loading from jar using file: " + file);
                    stream = new FileInputStream(file);
                }
                try {
                    this.loadImplementationsInJar(packageName, stream, loader);
                }
                catch (IOException ioe) {
                    this.log.warning("Cannot search jar file '" + urlPath + "' for classes due to an IOException: " + ioe.getMessage(), ioe);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.log.debug("Cannot read entries in url: " + url, e);
            }
        }
    }

    protected void findInAllClasses(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        this.log.debug("Searching for: " + test + " in package: " + packageName);
        Set<Class> packageClasses = this.getFoundClasses(packageName);
        if (packageClasses == null) {
            this.log.debug("No classes found in package: " + packageName);
            return;
        }
        for (Class type : packageClasses) {
            if (!test.matches(type)) continue;
            classes.add(type);
        }
    }

    protected void addFoundClass(Class<?> type) {
        if (type.getPackage() != null) {
            String packageName = type.getPackage().getName();
            List<String> packageNameParts = Arrays.asList(packageName.split("\\."));
            for (int i = 0; i < packageNameParts.size(); ++i) {
                String thisPackage = StringUtils.join(packageNameParts.subList(0, i + 1), "/");
                this.addFoundClass(thisPackage, type);
            }
        }
    }

    protected void addFoundClass(String packageName, Class<?> type) {
        if (!this.allClassesByPackage.containsKey(packageName = packageName.replace("/", "."))) {
            this.allClassesByPackage.put(packageName, new HashSet());
        }
        this.allClassesByPackage.get(packageName).add(type);
    }

    protected Set<Class> getFoundClasses(String packageName) {
        packageName = packageName.replace("/", ".");
        return this.allClassesByPackage.get(packageName);
    }

    protected URL customResourceLocator(URL url) throws IOException {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.log.debug("Getting resource URL for package: " + packageName + " with classloader: " + loader);
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(String parent, File location, ClassLoader classLoader) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(packageOrClass, file, classLoader);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.loadClass(packageOrClass, classLoader);
        }
    }

    private void loadClass(String className, ClassLoader classLoader) {
        try {
            String externalName = className.substring(0, className.indexOf(46)).replace('/', '.');
            Class<?> type = classLoader.loadClass(externalName);
            this.log.debug("Loaded the class: " + type + " in classloader: " + classLoader);
            if (Modifier.isAbstract(type.getModifiers()) || Modifier.isInterface(type.getModifiers())) {
                return;
            }
            this.addFoundClass(type);
        }
        catch (ClassNotFoundException e) {
            this.log.debug("Cannot find class '" + className + "' in classloader: " + classLoader + ". Reason: " + e, e);
        }
        catch (NoClassDefFoundError e) {
            this.log.debug("Cannot find the class definition '" + className + "' in classloader: " + classLoader + ". Reason: " + e, e);
        }
        catch (LinkageError e) {
            this.log.debug("Cannot find the class definition '" + className + "' in classloader: " + classLoader + ". Reason: " + e, e);
        }
        catch (Throwable e) {
            this.log.severe("Cannot load class '" + className + "' in classloader: " + classLoader + ".  Reason: " + e, e);
        }
    }

    protected void loadImplementationsInJar(String parent, InputStream stream, ClassLoader loader) throws IOException {
        JarEntry entry;
        JarInputStream jarStream = null;
        jarStream = stream instanceof JarInputStream ? (JarInputStream)stream : new JarInputStream(stream);
        while ((entry = jarStream.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (name == null || !name.contains(parent)) continue;
            name = name.trim();
            if (entry.isDirectory() || !name.endsWith(".class")) continue;
            this.loadClass(name, loader);
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class<?>> classes) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Set<ClassLoader> set = this.getClassLoaders();
            boolean found = false;
            for (ClassLoader classLoader : set) {
                this.log.debug("Testing that class " + externalName + " matches criteria [" + test + "] using classloader:" + classLoader);
                try {
                    Class<?> type = classLoader.loadClass(externalName);
                    this.log.debug("Loaded the class: " + type + " in classloader: " + classLoader);
                    if (test.matches(type)) {
                        this.log.debug("Found class: " + type + " which matches the filter in classloader: " + classLoader);
                        classes.add(type);
                    }
                    found = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    this.log.debug("Cannot find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e, e);
                }
                catch (NoClassDefFoundError e) {
                    this.log.debug("Cannot find the class definition '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e, e);
                }
                catch (LinkageError e) {
                    this.log.debug("Cannot find the class definition '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e, e);
                }
                catch (Throwable e) {
                    this.log.severe("Cannot load class '" + fqn + "' in classloader: " + classLoader + ".  Reason: " + e, e);
                }
            }
            if (!found) {
                this.log.debug("Cannot find class '" + fqn + "' in any classloaders: " + set);
            }
        }
        catch (Exception e) {
            this.log.warning("Cannot examine class '" + fqn + "' due to a " + e.getClass().getName() + " with message: " + e.getMessage(), e);
        }
    }
}

