/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import java.net.URI;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.config.SecurityActions;

public class IDPMetadataConfigurationProvider
extends AbstractSAMLConfigurationProvider {
    public static final String DEFAULT_IDP_MD_FILE = "idp-metadata.xml";
    private String idpMetadataLocation;

    @Override
    public IDPType getIDPConfiguration() throws ProcessingException {
        IDPType idpType = null;
        if (this.fileAvailable()) {
            try {
                EntitiesDescriptorType entities = this.parseMDFile();
                if (entities == null) {
                    throw logger.nullValueError("entities");
                }
                IDPSSODescriptorType idpSSO = CoreConfigUtil.getIDPDescriptor(entities);
                if (idpSSO != null) {
                    idpType = CoreConfigUtil.getIDPType(idpSSO);
                }
                this.configureTrustedDomainsFromMetadata(idpType, entities);
            }
            catch (ParsingException e) {
                throw logger.processingError((Throwable)e);
            }
        } else {
            throw logger.nullValueError(this.getIdpMetadataLocation());
        }
        if (this.configParsedIDPType != null) {
            idpType.importFrom(this.configParsedIDPType);
        }
        return idpType;
    }

    @Override
    public SPType getSPConfiguration() throws ProcessingException {
        throw new RuntimeException("PL00020: Illegal Method Called");
    }

    private boolean fileAvailable() {
        InputStream is = SecurityActions.loadStream(this.getClass(), this.getIdpMetadataLocation());
        return is != null;
    }

    private EntitiesDescriptorType parseMDFile() throws ParsingException {
        EntitiesDescriptorType entities;
        InputStream is = SecurityActions.loadStream(this.getClass(), this.getIdpMetadataLocation());
        if (is == null) {
            throw logger.nullValueError(this.getIdpMetadataLocation());
        }
        Object idpMetadata = new SAMLParser().parse(is);
        if (EntitiesDescriptorType.class.isInstance(idpMetadata)) {
            entities = (EntitiesDescriptorType)idpMetadata;
        } else {
            entities = new EntitiesDescriptorType();
            entities.addEntityDescriptor(idpMetadata);
        }
        return entities;
    }

    private void configureTrustedDomainsFromMetadata(IDPType idpType, EntitiesDescriptorType entities) {
        if (idpType.getTrust() == null) {
            idpType.setTrust(new TrustType());
        }
        for (Object entityDescriptorObj : entities.getEntityDescriptor()) {
            EntityDescriptorType entityDescriptorType = (EntityDescriptorType)entityDescriptorObj;
            SPSSODescriptorType spDescriptor = CoreConfigUtil.getSPDescriptor(entityDescriptorType);
            if (spDescriptor == null) continue;
            for (IndexedEndpointType assertionConsumerService : spDescriptor.getAssertionConsumerService()) {
                URI location = assertionConsumerService.getLocation();
                idpType.getTrust().addDomain(location.getHost());
            }
        }
    }

    public String getIdpMetadataLocation() {
        if (this.idpMetadataLocation == null) {
            this.idpMetadataLocation = DEFAULT_IDP_MD_FILE;
        }
        return this.idpMetadataLocation;
    }

    public void setIdpMetadataLocation(String idpMetadataLocation) {
        this.idpMetadataLocation = idpMetadataLocation;
    }
}

