/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.keycloak.freemarker.Theme;

public class ClassLoaderTheme
implements Theme {
    private String name;
    private String parentName;
    private String importName;
    private Theme.Type type;
    private ClassLoader classLoader;
    private String templateRoot;
    private String resourceRoot;
    private String messages;
    private Properties properties;

    public ClassLoaderTheme(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        this.init(name, type, classLoader);
    }

    public void init(String name, Theme.Type type, ClassLoader classLoader) throws IOException {
        String themeRoot;
        this.name = name;
        this.type = type;
        this.classLoader = classLoader;
        this.templateRoot = themeRoot = "theme/" + type.toString().toLowerCase() + "/" + name + "/";
        this.resourceRoot = themeRoot + "resources/";
        this.messages = themeRoot + "messages/messages.properties";
        this.properties = new Properties();
        URL p = classLoader.getResource(themeRoot + "theme.properties");
        if (p != null) {
            this.properties.load(p.openStream());
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        } else {
            this.parentName = null;
            this.importName = null;
        }
    }

    public ClassLoaderTheme() {
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) {
        return this.classLoader.getResource(this.templateRoot + name);
    }

    public InputStream getTemplateAsStream(String name) {
        return this.classLoader.getResourceAsStream(this.templateRoot + name);
    }

    public URL getResource(String path) {
        return this.classLoader.getResource(this.resourceRoot + path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.classLoader.getResourceAsStream(this.resourceRoot + path);
    }

    public Properties getMessages() throws IOException {
        Properties m = new Properties();
        URL url = this.classLoader.getResource(this.messages);
        if (url != null) {
            m.load(url.openStream());
        }
        return m;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

