/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private EmitValue emit = EmitValue.ENTITY;
    private String user;
    private Long expired;
    private Long expiredRefresh;

    public UserSessionMapper(String realm) {
        this.realm = realm;
    }

    public static UserSessionMapper create(String realm) {
        return new UserSessionMapper(realm);
    }

    public UserSessionMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public UserSessionMapper user(String user) {
        this.user = user;
        return this;
    }

    public UserSessionMapper expired(long expired, long expiredRefresh) {
        this.expired = expired;
        this.expiredRefresh = expiredRefresh;
        return this;
    }

    public void map(String key, SessionEntity e, Collector collector) {
        if (!(e instanceof UserSessionEntity)) {
            return;
        }
        UserSessionEntity entity = (UserSessionEntity)e;
        if (!this.realm.equals(entity.getRealm())) {
            return;
        }
        if (this.user != null && !entity.getUser().equals(this.user)) {
            return;
        }
        if (this.expired != null && this.expiredRefresh != null && (long)entity.getStarted() > this.expired && (long)entity.getLastSessionRefresh() > this.expiredRefresh) {
            return;
        }
        switch (this.emit) {
            case KEY: {
                collector.emit((Object)key, (Object)key);
                break;
            }
            case ENTITY: {
                collector.emit((Object)key, (Object)entity);
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY;

    }
}

