/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailProvider;
import org.keycloak.freemarker.BrowserSecurityHeaderSetup;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.FreeMarkerUtil;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.login.LoginFormsPages;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.login.freemarker.Templates;
import org.keycloak.login.freemarker.model.ClientBean;
import org.keycloak.login.freemarker.model.CodeBean;
import org.keycloak.login.freemarker.model.LoginBean;
import org.keycloak.login.freemarker.model.MessageBean;
import org.keycloak.login.freemarker.model.OAuthGrantBean;
import org.keycloak.login.freemarker.model.ProfileBean;
import org.keycloak.login.freemarker.model.RealmBean;
import org.keycloak.login.freemarker.model.RegisterBean;
import org.keycloak.login.freemarker.model.SocialBean;
import org.keycloak.login.freemarker.model.TotpBean;
import org.keycloak.login.freemarker.model.UrlBean;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.flows.Urls;

public class FreeMarkerLoginFormsProvider
implements LoginFormsProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerLoginFormsProvider.class);
    private String message;
    private String accessCode;
    private Response.Status status = Response.Status.OK;
    private List<RoleModel> realmRolesRequested;
    private MultivaluedMap<String, RoleModel> resourceRolesRequested;
    private MultivaluedMap<String, String> queryParams;
    private MessageType messageType = MessageType.ERROR;
    private MultivaluedMap<String, String> formData;
    private KeycloakSession session;
    private FreeMarkerUtil freeMarker;
    private RealmModel realm;
    private UserModel user;
    private ClientModel client;
    private UriInfo uriInfo;

    public FreeMarkerLoginFormsProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
    }

    public LoginFormsProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public LoginFormsProvider setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public Response createResponse(UserModel.RequiredAction action) {
        LoginFormsPages page;
        String actionMessage;
        switch (action) {
            case CONFIGURE_TOTP: {
                actionMessage = "actionTotpWarning";
                page = LoginFormsPages.LOGIN_CONFIG_TOTP;
                break;
            }
            case UPDATE_PROFILE: {
                actionMessage = "actionProfileWarning";
                page = LoginFormsPages.LOGIN_UPDATE_PROFILE;
                break;
            }
            case UPDATE_PASSWORD: {
                actionMessage = "actionPasswordWarning";
                page = LoginFormsPages.LOGIN_UPDATE_PASSWORD;
                break;
            }
            case VERIFY_EMAIL: {
                try {
                    UriBuilder builder = Urls.loginActionEmailVerificationBuilder((URI)this.uriInfo.getBaseUri());
                    builder.queryParam("key", new Object[]{this.accessCode});
                    String link = builder.build(new Object[]{this.realm.getName()}).toString();
                    long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
                    ((EmailProvider)this.session.getProvider(EmailProvider.class)).setRealm(this.realm).setUser(this.user).sendVerifyEmail(link, expiration);
                }
                catch (EmailException e) {
                    logger.error((Object)"Failed to send verification email", (Throwable)e);
                    return this.setError("emailSendError").createErrorPage();
                }
                actionMessage = "actionEmailWarning";
                page = LoginFormsPages.LOGIN_VERIFY_EMAIL;
                break;
            }
            default: {
                return Response.serverError().build();
            }
        }
        if (this.message == null) {
            this.setWarning(actionMessage);
        }
        return this.createResponse(page);
    }

    private Response createResponse(LoginFormsPages page) {
        Properties messages;
        Theme theme;
        MultivaluedMapImpl queryParameterMap = this.queryParams != null ? this.queryParams : new MultivaluedMapImpl();
        String requestURI = this.uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        for (String k : queryParameterMap.keySet()) {
            Object[] objects = ((List)queryParameterMap.get((Object)k)).toArray();
            if (objects.length == 1 && objects[0] == null) continue;
            uriBuilder.replaceQueryParam(k, objects);
        }
        if (this.accessCode != null) {
            uriBuilder.replaceQueryParam("code", new Object[]{this.accessCode});
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        try {
            theme = themeProvider.getTheme(this.realm.getLoginTheme(), Theme.Type.LOGIN);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        try {
            messages = theme.getMessages();
            attributes.put("rb", messages);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messages = new Properties();
        }
        if (this.message != null) {
            attributes.put("message", new MessageBean(messages.containsKey(this.message) ? messages.getProperty(this.message) : this.message, this.messageType));
        }
        if (page == LoginFormsPages.OAUTH_GRANT) {
            uriBuilder.replaceQuery(null);
        }
        URI baseUri = uriBuilder.build(new Object[0]);
        if (this.realm != null) {
            attributes.put("realm", new RealmBean(this.realm));
            attributes.put("social", new SocialBean(this.realm, baseUri));
            attributes.put("url", new UrlBean(this.realm, theme, baseUri));
        }
        if (this.client != null) {
            attributes.put("client", new ClientBean(this.client));
        }
        attributes.put("login", new LoginBean(this.formData));
        switch (page) {
            case LOGIN_CONFIG_TOTP: {
                attributes.put("totp", new TotpBean(this.realm, this.user, baseUri));
                break;
            }
            case LOGIN_UPDATE_PROFILE: {
                attributes.put("user", new ProfileBean(this.user));
                break;
            }
            case REGISTER: {
                attributes.put("register", new RegisterBean(this.formData));
                break;
            }
            case OAUTH_GRANT: {
                attributes.put("oauth", new OAuthGrantBean(this.accessCode, this.client, this.realmRolesRequested, this.resourceRolesRequested));
                break;
            }
            case CODE: {
                attributes.put("code", new CodeBean(this.accessCode, this.messageType == MessageType.ERROR ? this.message : null));
            }
        }
        try {
            String result = this.freeMarker.processTemplate(attributes, Templates.getTemplate(page), theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).type("text/html").entity((Object)result);
            BrowserSecurityHeaderSetup.headers((Response.ResponseBuilder)builder, (RealmModel)this.realm);
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response createLogin() {
        return this.createResponse(LoginFormsPages.LOGIN);
    }

    public Response createPasswordReset() {
        return this.createResponse(LoginFormsPages.LOGIN_RESET_PASSWORD);
    }

    public Response createLoginTotp() {
        return this.createResponse(LoginFormsPages.LOGIN_TOTP);
    }

    public Response createRegistration() {
        return this.createResponse(LoginFormsPages.REGISTER);
    }

    public Response createErrorPage() {
        this.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
        return this.createResponse(LoginFormsPages.ERROR);
    }

    public Response createOAuthGrant() {
        return this.createResponse(LoginFormsPages.OAUTH_GRANT);
    }

    public Response createCode() {
        return this.createResponse(LoginFormsPages.CODE);
    }

    public FreeMarkerLoginFormsProvider setError(String message) {
        this.message = message;
        this.messageType = MessageType.ERROR;
        return this;
    }

    public FreeMarkerLoginFormsProvider setSuccess(String message) {
        this.message = message;
        this.messageType = MessageType.SUCCESS;
        return this;
    }

    public FreeMarkerLoginFormsProvider setWarning(String message) {
        this.message = message;
        this.messageType = MessageType.WARNING;
        return this;
    }

    public FreeMarkerLoginFormsProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public FreeMarkerLoginFormsProvider setClient(ClientModel client) {
        this.client = client;
        return this;
    }

    public FreeMarkerLoginFormsProvider setFormData(MultivaluedMap<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public LoginFormsProvider setClientSessionCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public LoginFormsProvider setAccessRequest(List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested) {
        this.realmRolesRequested = realmRolesRequested;
        this.resourceRolesRequested = resourceRolesRequested;
        return this;
    }

    public LoginFormsProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public LoginFormsProvider setQueryParams(MultivaluedMap<String, String> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public void close() {
    }

    public static enum MessageType {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

