/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.net.URI;
import java.security.PublicKey;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClaimMask;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.saml.SALM2LoginResponseBuilder;
import org.keycloak.protocol.saml.SAML2ErrorResponseBuilder;
import org.keycloak.protocol.saml.SAML2LogoutRequestBuilder;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.flows.Flows;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.X500SAMLProfileConstants;

public class SamlProtocol
implements LoginProtocol {
    protected static final Logger logger = Logger.getLogger(SamlProtocol.class);
    public static final String ATTRIBUTE_TRUE_VALUE = "true";
    public static final String ATTRIBUTE_FALSE_VALUE = "false";
    public static final String SAML_SIGNING_CERTIFICATE_ATTRIBUTE = "saml.signing.certificate";
    public static final String SAML_ENCRYPTION_CERTIFICATE_ATTRIBUTE = "saml.encryption.certificate";
    public static final String SAML_CLIENT_SIGNATURE_ATTRIBUTE = "saml.client.signature";
    public static final String LOGIN_PROTOCOL = "saml";
    public static final String SAML_BINDING = "saml_binding";
    public static final String SAML_POST_BINDING = "post";
    public static final String SAML_GET_BINDING = "get";
    public static final String SAML_SERVER_SIGNATURE = "saml.server.signature";
    public static final String SAML_ASSERTION_SIGNATURE = "saml.assertion.signature";
    public static final String SAML_AUTHNSTATEMENT = "saml.authnstatement";
    public static final String SAML_MULTIVALUED_ROLES = "saml.multivalued.roles";
    public static final String SAML_SIGNATURE_ALGORITHM = "saml.signature.algorithm";
    public static final String SAML_ENCRYPT = "saml.encrypt";
    public static final String SAML_FORCE_POST_BINDING = "saml.force.post.binding";
    public static final String SAML_REQUEST_ID = "SAML_REQUEST_ID";
    public static final String SAML_DEFAULT_NAMEID_FORMAT = JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get();
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;

    public SamlProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public SamlProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public SamlProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public Response cancelLogin(ClientSessionModel clientSession) {
        return this.getErrorResponse(clientSession, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
    }

    public Response invalidSessionError(ClientSessionModel clientSession) {
        return this.getErrorResponse(clientSession, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get());
    }

    protected String getResponseIssuer(RealmModel realm) {
        return RealmsResource.realmBaseUrl((UriInfo)this.uriInfo).build(new Object[]{realm.getName()}).toString();
    }

    protected Response getErrorResponse(ClientSessionModel clientSession, String status) {
        SAML2ErrorResponseBuilder builder = ((SAML2ErrorResponseBuilder)((SAML2ErrorResponseBuilder)((SAML2ErrorResponseBuilder)new SAML2ErrorResponseBuilder().relayState(clientSession.getNote("RelayState"))).destination(clientSession.getRedirectUri())).responseIssuer(this.getResponseIssuer(this.realm))).status(status);
        try {
            if (this.isPostBinding(clientSession)) {
                return builder.postBinding().response();
            }
            return builder.redirectBinding().response();
        }
        catch (Exception e) {
            return Flows.forwardToSecurityFailurePage((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)this.uriInfo, (String)"Failed to process response");
        }
    }

    protected boolean isPostBinding(ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        return SAML_POST_BINDING.equals(clientSession.getNote(SAML_BINDING)) || ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_FORCE_POST_BINDING));
    }

    protected String getNameIdFormat(ClientSessionModel clientSession) {
        String nameIdFormat = clientSession.getNote("NAMEID_FORMAT");
        if (nameIdFormat == null) {
            return SAML_DEFAULT_NAMEID_FORMAT;
        }
        return nameIdFormat;
    }

    protected String getNameId(String nameIdFormat, ClientSessionModel clientSession, UserSessionModel userSession) {
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
            return userSession.getUser().getEmail();
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get())) {
            return userSession.getUser().getUsername();
        }
        return userSession.getUser().getUsername();
    }

    public Response authenticated(UserSessionModel userSession, ClientSessionCode accessCode) {
        ClientSessionModel clientSession = accessCode.getClientSession();
        ClientModel client = clientSession.getClient();
        String requestID = clientSession.getNote(SAML_REQUEST_ID);
        String relayState = clientSession.getNote("RelayState");
        String redirectUri = clientSession.getRedirectUri();
        String responseIssuer = this.getResponseIssuer(this.realm);
        String nameIdFormat = this.getNameIdFormat(clientSession);
        String nameId = this.getNameId(nameIdFormat, clientSession, userSession);
        SALM2LoginResponseBuilder builder = new SALM2LoginResponseBuilder();
        ((SALM2LoginResponseBuilder)((SALM2LoginResponseBuilder)((SALM2LoginResponseBuilder)builder.requestID(requestID).relayState(relayState)).destination(redirectUri)).responseIssuer(responseIssuer)).requestIssuer(clientSession.getClient().getClientId()).nameIdentifier(nameIdFormat, nameId).authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get());
        this.initClaims(builder, clientSession.getClient(), userSession.getUser());
        if (clientSession.getRoles() != null) {
            if (this.multivaluedRoles(client)) {
                builder.multiValuedRoles(true);
            }
            for (String roleId : clientSession.getRoles()) {
                RoleModel roleModel = clientSession.getRealm().getRoleById(roleId);
                builder.roles(roleModel.getName());
            }
        }
        if (this.requiresRealmSignature(client)) {
            ((SALM2LoginResponseBuilder)((SALM2LoginResponseBuilder)builder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signDocument();
        }
        if (this.requiresAssertionSignature(client)) {
            ((SALM2LoginResponseBuilder)((SALM2LoginResponseBuilder)builder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signAssertions();
        }
        if (!this.includeAuthnStatement(client)) {
            builder.disableAuthnStatement(true);
        }
        if (this.requiresEncryption(client)) {
            PublicKey publicKey = null;
            try {
                publicKey = SamlProtocolUtils.getEncryptionValidationKey(client);
            }
            catch (Exception e) {
                logger.error((Object)"failed", (Throwable)e);
                return Flows.forwardToSecurityFailurePage((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)this.uriInfo, (String)"Failed to process response");
            }
            builder.encrypt(publicKey);
        }
        try {
            if (this.isPostBinding(clientSession)) {
                return builder.postBinding().response();
            }
            return builder.redirectBinding().response();
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return Flows.forwardToSecurityFailurePage((KeycloakSession)this.session, (RealmModel)this.realm, (UriInfo)this.uriInfo, (String)"Failed to process response");
        }
    }

    private boolean requiresRealmSignature(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_SERVER_SIGNATURE));
    }

    private boolean requiresAssertionSignature(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_ASSERTION_SIGNATURE));
    }

    private boolean includeAuthnStatement(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_AUTHNSTATEMENT));
    }

    private boolean multivaluedRoles(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_MULTIVALUED_ROLES));
    }

    public static SignatureAlgorithm getSignatureAlgorithm(ClientModel client) {
        SignatureAlgorithm algorithm;
        String alg = client.getAttribute(SAML_SIGNATURE_ALGORITHM);
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf(alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    private boolean requiresEncryption(ClientModel client) {
        return ATTRIBUTE_TRUE_VALUE.equals(client.getAttribute(SAML_ENCRYPT));
    }

    public void initClaims(SALM2LoginResponseBuilder builder, ClientModel model, UserModel user) {
        if (ClaimMask.hasEmail((long)model.getAllowedClaimsMask())) {
            builder.attribute(X500SAMLProfileConstants.EMAIL_ADDRESS.getFriendlyName(), user.getEmail());
        }
        if (ClaimMask.hasName((long)model.getAllowedClaimsMask())) {
            builder.attribute(X500SAMLProfileConstants.GIVEN_NAME.getFriendlyName(), user.getFirstName());
            builder.attribute(X500SAMLProfileConstants.SURNAME.getFriendlyName(), user.getLastName());
        }
        if (ClaimMask.hasUsername((long)model.getAllowedClaimsMask())) {
            builder.attribute(X500SAMLProfileConstants.USERID.getFriendlyName(), user.getUsername());
        }
    }

    public Response consentDenied(ClientSessionModel clientSession) {
        return this.getErrorResponse(clientSession, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        if (!(client instanceof ApplicationModel)) {
            return;
        }
        ApplicationModel app = (ApplicationModel)client;
        if (app.getManagementUrl() == null) {
            return;
        }
        SAML2LogoutRequestBuilder logoutBuilder = (SAML2LogoutRequestBuilder)new SAML2LogoutRequestBuilder().userPrincipal(userSession.getUser().getUsername()).destination(client.getClientId());
        if (this.requiresRealmSignature(client)) {
            ((SAML2LogoutRequestBuilder)((SAML2LogoutRequestBuilder)logoutBuilder.signatureAlgorithm(SamlProtocol.getSignatureAlgorithm(client))).signWith(this.realm.getPrivateKey(), this.realm.getPublicKey(), this.realm.getCertificate())).signDocument();
        }
        String logoutRequestString = null;
        try {
            logoutRequestString = logoutBuilder.postBinding().encoded();
        }
        catch (Exception e) {
            logger.warn((Object)"failed to send saml logout", (Throwable)e);
            return;
        }
        String adminUrl = ResourceAdminManager.getManagementUrl((URI)this.uriInfo.getRequestUri(), (ApplicationModel)app);
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            ClientRequest request = executor.createRequest(adminUrl);
            request.formParameter("SAMLRequest", (Object)logoutRequestString);
            request.formParameter("BACK_CHANNEL_LOGOUT", (Object)"BACK_CHANNEL_LOGOUT");
            ClientResponse response = null;
            try {
                response = request.post();
                response.releaseConnection();
                if (response.getStatus() == 302 && !adminUrl.endsWith("/")) {
                    String redirect = (String)response.getHeaders().getFirst((Object)"Location");
                    String withSlash = adminUrl + "/";
                    if (withSlash.equals(redirect)) {
                        request = executor.createRequest(withSlash);
                        request.formParameter("SAMLRequest", (Object)logoutRequestString);
                        request.formParameter("BACK_CHANNEL_LOGOUT", (Object)"BACK_CHANNEL_LOGOUT");
                        response = request.post();
                        response.releaseConnection();
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"failed to send saml logout", (Throwable)e);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    public void close() {
    }
}

