/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.security.Signature;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.ClientConnection;
import org.keycloak.VerificationException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OpenIDConnectService;
import org.keycloak.protocol.saml.SAMLRequestParser;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.util.StreamUtil;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;

public class SamlService {
    protected static final Logger logger = Logger.getLogger(SamlService.class);
    protected RealmModel realm;
    private EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public SamlService(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        this.realm = realm;
        this.event = event;
        this.authManager = authManager;
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        return new RedirectBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        return new PostBindingProtocol().execute(samlRequest, samlResponse, relayState);
    }

    @GET
    @Path(value="descriptor")
    @Produces(value={"application/xml"})
    public String getDescriptor() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/idp-metadata-template.xml");
        String template = StreamUtil.readString((InputStream)is);
        template = template.replace("${idp.entityID}", RealmsResource.realmBaseUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName()}).toString());
        template = template.replace("${idp.sso.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sso.HTTP-Redirect}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.sls.HTTP-POST}", RealmsResource.protocolUrl((UriInfo)this.uriInfo).build(new Object[]{this.realm.getName(), "saml"}).toString());
        template = template.replace("${idp.signing.certificate}", this.realm.getCertificatePem());
        return template;
    }

    protected class RedirectBindingProtocol
    extends BindingProtocol {
        protected RedirectBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            if (!"true".equals(client.getAttribute("saml.client.signature"))) {
                return;
            }
            MultivaluedMap encodedParams = SamlService.this.uriInfo.getQueryParameters(false);
            String request = (String)encodedParams.getFirst((Object)"SAMLRequest");
            String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
            String signature = (String)encodedParams.getFirst((Object)"Signature");
            if (request == null) {
                throw new VerificationException("SAMLRequest as null");
            }
            if (algorithm == null) {
                throw new VerificationException("SigAlg as null");
            }
            if (signature == null) {
                throw new VerificationException("Signature as null");
            }
            PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
            UriBuilder builder = UriBuilder.fromPath((String)"/").queryParam("SAMLRequest", new Object[]{request});
            if (encodedParams.containsKey((Object)"RelayState")) {
                builder.queryParam("RelayState", new Object[]{encodedParams.getFirst((Object)"RelayState")});
            }
            builder.queryParam("SigAlg", new Object[]{algorithm});
            String rawQuery = builder.build(new Object[0]).getRawQuery();
            try {
                byte[] decodedSignature = RedirectBindingUtil.urlBase64Decode((String)signature);
                SignatureAlgorithm signatureAlgorithm = SamlProtocol.getSignatureAlgorithm(client);
                Signature validator = signatureAlgorithm.createSignature();
                validator.initVerify(publicKey);
                validator.update(rawQuery.getBytes("UTF-8"));
                if (!validator.verify(decodedSignature)) {
                    throw new VerificationException("Invalid query param signature");
                }
            }
            catch (Exception e) {
                throw new VerificationException((Throwable)e);
            }
        }

        @Override
        protected SAMLDocumentHolder extractDocument(String samlRequest) {
            return SAMLRequestParser.parseRedirectBinding(samlRequest);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    protected class PostBindingProtocol
    extends BindingProtocol {
        protected PostBindingProtocol() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder, ClientModel client) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature(client, documentHolder.getSamlDocument());
        }

        @Override
        protected SAMLDocumentHolder extractDocument(String samlRequest) {
            return SAMLRequestParser.parsePostBinding(samlRequest);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }
    }

    public abstract class BindingProtocol {
        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("ssl_required");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"HTTPS required");
            }
            if (!SamlService.this.realm.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN_ERROR);
                SamlService.this.event.error("realm_disabled");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Realm not enabled");
            }
            if (samlRequest == null && samlResponse == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid Request");
            }
            return null;
        }

        protected Response handleSamlResponse(String samleResponse, String relayState) {
            SamlService.this.event.event(EventType.LOGIN);
            SamlService.this.event.error("invalid_token");
            return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid Request");
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder documentHolder = this.extractDocument(samlRequest);
            if (documentHolder == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_token");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid Request");
            }
            SAML2Object samlObject = documentHolder.getSamlObject();
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            String issuer = requestAbstractType.getIssuer().getValue();
            ClientModel client = SamlService.this.realm.findClient(issuer);
            if (client == null) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Unknown login requester.");
            }
            if (!client.isEnabled()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("client_disabled");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Login requester not enabled.");
            }
            if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Bearer-only applications are not allowed to initiate browser login");
            }
            if (client.isDirectGrantsOnly()) {
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("not_allowed");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"direct-grants-only clients are not allowed to initiate browser login");
            }
            try {
                this.verifySignature(documentHolder, client);
            }
            catch (VerificationException e) {
                logger.error((Object)"request validation failed", (Throwable)e);
                SamlService.this.event.event(EventType.LOGIN);
                SamlService.this.event.error("invalid_signature");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid requester.");
            }
            if (samlObject instanceof AuthnRequestType) {
                SamlService.this.event.event(EventType.LOGIN);
                AuthnRequestType authn = (AuthnRequestType)samlObject;
                return this.loginRequest(relayState, authn, client);
            }
            if (samlObject instanceof LogoutRequestType) {
                SamlService.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)samlObject;
                return this.logoutRequest(logout, client);
            }
            SamlService.this.event.event(EventType.LOGIN);
            SamlService.this.event.error("invalid_token");
            return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid Request");
        }

        protected abstract void verifySignature(SAMLDocumentHolder var1, ClientModel var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractDocument(String var1);

        /*
         * Enabled aggressive block sorting
         */
        protected Response loginRequest(String relayState, AuthnRequestType requestAbstractType, ClientModel client) {
            URI redirectUri = requestAbstractType.getAssertionConsumerServiceURL();
            String redirect = OpenIDConnectService.verifyRedirectUri((UriInfo)SamlService.this.uriInfo, (String)redirectUri.toString(), (RealmModel)SamlService.this.realm, (ClientModel)client);
            if (redirect == null) {
                SamlService.this.event.error("invalid_redirect_uri");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid redirect_uri.");
            }
            ClientSessionModel clientSession = SamlService.this.session.sessions().createClientSession(SamlService.this.realm, client);
            clientSession.setAuthMethod("saml");
            clientSession.setRedirectUri(redirect);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE);
            clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            clientSession.setNote("saml_binding", this.getBindingType());
            clientSession.setNote("RelayState", relayState);
            clientSession.setNote("SAML_REQUEST_ID", requestAbstractType.getID());
            NameIDPolicyType nameIdPolicy = requestAbstractType.getNameIDPolicy();
            if (nameIdPolicy != null) {
                String nameIdFormat = nameIdPolicy.getFormat().toString();
                if (!this.isSupportedNameIdFormat(nameIdFormat)) {
                    SamlService.this.event.error("invalid_token");
                    return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Unsupported NameIDFormat.");
                }
                clientSession.setNote("NAMEID_FORMAT", nameIdFormat);
            } else {
                clientSession.setNote("NAMEID_FORMAT", JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
            }
            Response response = SamlService.this.authManager.checkNonFormAuthentication(SamlService.this.session, clientSession, SamlService.this.realm, SamlService.this.uriInfo, SamlService.this.request, SamlService.this.clientConnection, SamlService.this.headers, SamlService.this.event);
            if (response != null) {
                return response;
            }
            LoginFormsProvider forms = Flows.forms((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (ClientModel)clientSession.getClient(), (UriInfo)SamlService.this.uriInfo).setClientSessionCode(new ClientSessionCode(SamlService.this.realm, clientSession).getCode());
            String rememberMeUsername = AuthenticationManager.getRememberMeUsername((RealmModel)SamlService.this.realm, (HttpHeaders)SamlService.this.headers);
            if (rememberMeUsername != null) {
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
                forms.setFormData((MultivaluedMap)formData);
            }
            return forms.createLogin();
        }

        private boolean isSupportedNameIdFormat(String nameIdFormat) {
            return nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()) || nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        }

        protected abstract String getBindingType();

        protected Response logoutRequest(LogoutRequestType requestAbstractType, ClientModel client) {
            AuthenticationManager.AuthResult authResult = SamlService.this.authManager.authenticateIdentityCookie(SamlService.this.session, SamlService.this.realm, SamlService.this.uriInfo, SamlService.this.clientConnection, SamlService.this.headers, false);
            if (authResult != null) {
                this.logout(authResult.getSession());
            }
            String redirectUri = null;
            if (client instanceof ApplicationModel) {
                redirectUri = ((ApplicationModel)client).getBaseUrl();
            }
            if (redirectUri != null) {
                String validatedRedirect = OpenIDConnectService.verifyRedirectUri((UriInfo)SamlService.this.uriInfo, (String)redirectUri, (RealmModel)SamlService.this.realm, (ClientModel)client);
                if (validatedRedirect == null) {
                    return Flows.forwardToSecurityFailurePage((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UriInfo)SamlService.this.uriInfo, (String)"Invalid redirect uri.");
                }
                return Response.status((int)302).location(UriBuilder.fromUri((String)validatedRedirect).build(new Object[0])).build();
            }
            return Response.ok().build();
        }

        private void logout(UserSessionModel userSession) {
            AuthenticationManager cfr_ignored_0 = SamlService.this.authManager;
            AuthenticationManager.logout((KeycloakSession)SamlService.this.session, (RealmModel)SamlService.this.realm, (UserSessionModel)userSession, (UriInfo)SamlService.this.uriInfo, (ClientConnection)SamlService.this.clientConnection);
            SamlService.this.event.user(userSession.getUser()).session(userSession).success();
        }

        private boolean checkSsl() {
            if (SamlService.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SamlService.this.realm.getSslRequired().isRequired(SamlService.this.clientConnection);
        }
    }
}

