/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws.crypto;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSInput;

public class RSAProvider {
    public static String getJavaAlgorithm(Algorithm alg) {
        switch (alg) {
            case RS256: {
                return "SHA256withRSA";
            }
            case RS384: {
                return "SHA384withRSA";
            }
            case RS512: {
                return "SHA512withRSA";
            }
        }
        throw new IllegalArgumentException("Not an RSA Algorithm");
    }

    public static Signature getSignature(Algorithm alg) {
        try {
            return Signature.getInstance(RSAProvider.getJavaAlgorithm(alg));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sign(byte[] data, Algorithm algorithm, PrivateKey privateKey) {
        try {
            Signature signature = RSAProvider.getSignature(algorithm);
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(JWSInput input, PublicKey publicKey) {
        try {
            Signature verifier = RSAProvider.getSignature(input.getHeader().getAlgorithm());
            verifier.initVerify(publicKey);
            verifier.update(input.getEncodedSignatureInput().getBytes("UTF-8"));
            return verifier.verify(input.getSignature());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

