/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.OpenIDConnectService;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.EventsManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.ClientsManagementService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.PublicRealmResource;

@Path(value="/realms")
public class RealmsResource {
    protected static Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected BruteForceProtector protector;

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder realmBaseUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    public static UriBuilder protocolUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder protocolUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    @Path(value="{realm}/login-status-iframe.html")
    @GET
    @Produces(value={"text/html"})
    @Deprecated
    public Response getLoginStatusIframe(@PathParam(value="realm") String name, @QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "openid-connect");
        OpenIDConnectService endpoint = (OpenIDConnectService)factory.createProtocolEndpoint(realm, event, authManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.getLoginStatusIframe(client_id, origin);
    }

    @Path(value="{realm}/protocol/{protocol}")
    public Object getProtocol(@PathParam(value="realm") String name, @PathParam(value="protocol") String protocol) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        Object endpoint = factory.createProtocolEndpoint(realm, event, authManager);
        ResteasyProviderFactory.getInstance().injectProperties(endpoint);
        return endpoint;
    }

    @Path(value="{realm}/tokens")
    @Deprecated
    public Object getTokenService(@PathParam(value="realm") String name) {
        return this.getProtocol(name, "openid-connect");
    }

    @Path(value="{realm}/login-actions")
    public LoginActionsService getLoginActionsService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginActionsService service = new LoginActionsService(realm, authManager, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/clients-managements")
    public ClientsManagementService getClientsManagementService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        ClientsManagementService service = new ClientsManagementService(realm, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm " + name + " does not exist");
        }
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null || !application.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder();
        AccountService accountService = new AccountService(realm, application, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountService);
        accountService.init();
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)realmResource);
        return realmResource;
    }
}

