/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.ScopeMappedResource;

public class ScopeMappedApplicationResource {
    protected RealmModel realm;
    private RealmAuth auth;
    protected ClientModel client;
    protected KeycloakSession session;
    protected ApplicationModel app;

    public ScopeMappedApplicationResource(RealmModel realm, RealmAuth auth, ClientModel client, KeycloakSession session, ApplicationModel app) {
        this.realm = realm;
        this.auth = auth;
        this.client = client;
        this.session = session;
        this.app = app;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getApplicationScopeMappings() {
        this.auth.requireView();
        Set mappings = this.app.getApplicationScopeMappings(this.client);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableApplicationScopeMappings() {
        this.auth.requireView();
        Set roles = this.app.getRoles();
        return ScopeMappedResource.getAvailable(this.client, roles);
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeApplicationScopeMappings() {
        this.auth.requireView();
        Set roles = this.app.getRoles();
        return ScopeMappedResource.getComposite(this.client, roles);
    }

    @POST
    @Consumes(value={"application/json"})
    public void addApplicationScopeMapping(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.app.getRole(role.getName());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.client.addScopeMapping(roleModel);
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteApplicationScopeMapping(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        if (roles == null) {
            Set roleModels = this.app.getApplicationScopeMappings(this.client);
            for (RoleModel roleModel : roleModels) {
                this.client.deleteScopeMapping(roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.app.getRole(role.getName());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.client.deleteScopeMapping(roleModel);
            }
        }
    }
}

