/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.rotation;

import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpAdapterUtils;
import org.keycloak.adapters.HttpClientAdapterException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.util.JWKSUtils;

public class JWKPublicKeyLocator
implements PublicKeyLocator {
    private static final Logger log = Logger.getLogger(JWKPublicKeyLocator.class);
    private Map<String, PublicKey> currentKeys = new ConcurrentHashMap<String, PublicKey>();
    private volatile int lastRequestTime = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey getPublicKey(String kid, KeycloakDeployment deployment) {
        int minTimeBetweenRequests = deployment.getMinTimeBetweenJwksRequests();
        PublicKey publicKey = this.currentKeys.get(kid);
        if (publicKey != null) {
            return publicKey;
        }
        int currentTime = Time.currentTime();
        if (currentTime > this.lastRequestTime + minTimeBetweenRequests) {
            JWKPublicKeyLocator jWKPublicKeyLocator = this;
            synchronized (jWKPublicKeyLocator) {
                currentTime = Time.currentTime();
                if (currentTime > this.lastRequestTime + minTimeBetweenRequests) {
                    this.sendRequest(deployment);
                    this.lastRequestTime = currentTime;
                } else {
                    log.debugf("Won't send request to realm jwks url. Last request time was %d", this.lastRequestTime);
                }
            }
        }
        return this.currentKeys.get(kid);
    }

    private void sendRequest(KeycloakDeployment deployment) {
        if (log.isTraceEnabled()) {
            log.tracef("Going to send request to retrieve new set of realm public keys for client %s", (Object)deployment.getResourceName());
        }
        HttpGet getMethod = new HttpGet(deployment.getJwksUrl());
        try {
            JSONWebKeySet jwks = HttpAdapterUtils.sendJsonHttpRequest(deployment, (HttpRequestBase)getMethod, JSONWebKeySet.class);
            Map publicKeys = JWKSUtils.getKeysForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
            if (log.isDebugEnabled()) {
                log.debugf("Realm public keys successfully retrieved for client %s. New kids: %s", (Object)deployment.getResourceName(), (Object)publicKeys.keySet().toString());
            }
            this.currentKeys.clear();
            this.currentKeys.putAll(publicKeys);
        }
        catch (HttpClientAdapterException e) {
            log.error((Object)"Error when sending request to retrieve realm keys", (Throwable)e);
        }
    }
}

