/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.util.BasicAuthHelper;

public class Configuration {
    @JsonIgnore
    private HttpClient httpClient;
    @JsonProperty(value="auth-server-url")
    protected String authServerUrl;
    @JsonProperty(value="realm")
    protected String realm;
    @JsonProperty(value="resource")
    protected String clientId;
    @JsonProperty(value="credentials")
    protected Map<String, Object> clientCredentials = new HashMap<String, Object>();
    @JsonIgnore
    private ClientAuthenticator clientAuthenticator = new ClientAuthenticator(){

        @Override
        public void configureClientCredentials(HashMap<String, String> requestParams, HashMap<String, String> requestHeaders) {
            String secret = (String)Configuration.this.clientCredentials.get("secret");
            if (secret == null) {
                throw new RuntimeException("Client secret not provided.");
            }
            requestHeaders.put("Authorization", BasicAuthHelper.createHeader((String)Configuration.this.clientId, (String)secret));
        }
    };

    public Configuration() {
    }

    public Configuration(String authServerUrl, String realm, String clientId, Map<String, Object> clientCredentials, HttpClient httpClient) {
        this.authServerUrl = authServerUrl;
        this.realm = realm;
        this.clientId = clientId;
        this.clientCredentials = clientCredentials;
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return this.httpClient;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public ClientAuthenticator getClientAuthenticator() {
        return this.clientAuthenticator;
    }

    public Map<String, Object> getClientCredentials() {
        return this.clientCredentials;
    }

    public String getRealm() {
        return this.realm;
    }
}

