/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.keycloak.common.VerificationException;
import org.keycloak.jose.jws.AlgorithmType;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.AccessToken;

public class TokenVerifier {
    private final String tokenString;
    private PublicKey publicKey;
    private SecretKey secretKey;
    private String realmUrl;
    private boolean checkTokenType = true;
    private boolean checkActive = true;
    private boolean checkRealmUrl = true;
    private JWSInput jws;
    private AccessToken token;

    protected TokenVerifier(String tokenString) {
        this.tokenString = tokenString;
    }

    public static TokenVerifier create(String tokenString) {
        return new TokenVerifier(tokenString);
    }

    public TokenVerifier publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public TokenVerifier secretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public TokenVerifier realmUrl(String realmUrl) {
        this.realmUrl = realmUrl;
        return this;
    }

    public TokenVerifier checkTokenType(boolean checkTokenType) {
        this.checkTokenType = checkTokenType;
        return this;
    }

    public TokenVerifier checkActive(boolean checkActive) {
        this.checkActive = checkActive;
        return this;
    }

    public TokenVerifier checkRealmUrl(boolean checkRealmUrl) {
        this.checkRealmUrl = checkRealmUrl;
        return this;
    }

    public TokenVerifier parse() throws VerificationException {
        if (this.jws == null) {
            if (this.tokenString == null) {
                throw new VerificationException("Token not set");
            }
            try {
                this.jws = new JWSInput(this.tokenString);
            }
            catch (JWSInputException e) {
                throw new VerificationException("Failed to parse JWT", (Throwable)e);
            }
            try {
                this.token = this.jws.readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new VerificationException("Failed to read access token from JWT", (Throwable)e);
            }
        }
        return this;
    }

    public AccessToken getToken() throws VerificationException {
        this.parse();
        return this.token;
    }

    public JWSHeader getHeader() throws VerificationException {
        this.parse();
        return this.jws.getHeader();
    }

    public TokenVerifier verify() throws VerificationException {
        String user;
        this.parse();
        if (this.checkRealmUrl && this.realmUrl == null) {
            throw new VerificationException("Realm URL not set");
        }
        AlgorithmType algorithmType = this.getHeader().getAlgorithm().getType();
        if (AlgorithmType.RSA.equals((Object)algorithmType)) {
            if (this.publicKey == null) {
                throw new VerificationException("Public key not set");
            }
            if (!RSAProvider.verify(this.jws, this.publicKey)) {
                throw new VerificationException("Invalid token signature");
            }
        } else if (AlgorithmType.HMAC.equals((Object)algorithmType)) {
            if (this.secretKey == null) {
                throw new VerificationException("Secret key not set");
            }
            if (!HMACProvider.verify(this.jws, this.secretKey)) {
                throw new VerificationException("Invalid token signature");
            }
        } else {
            throw new VerificationException("Unknown or unsupported token algorith");
        }
        if ((user = this.token.getSubject()) == null) {
            throw new VerificationException("Subject missing in token");
        }
        if (this.checkRealmUrl && !this.realmUrl.equals(this.token.getIssuer())) {
            throw new VerificationException("Invalid token issuer. Expected '" + this.realmUrl + "', but was '" + this.token.getIssuer() + "'");
        }
        if (this.checkTokenType && !"Bearer".equalsIgnoreCase(this.token.getType())) {
            throw new VerificationException("Token type is incorrect. Expected 'Bearer' but was '" + this.token.getType() + "'");
        }
        if (this.checkActive && !this.token.isActive()) {
            throw new VerificationException("Token is not active");
        }
        return this;
    }
}

